/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common;

import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.UsAsciiUtils;

public enum StringPreparation {
    NO_PREPARATION{

        @Override
        char[] doNormalize(char[] value) {
            return UsAsciiUtils.toPrintable(value);
        }
    }
    ,
    SASL_PREPARATION{

        @Override
        char[] doNormalize(char[] value) {
            return ScramStringFormatting.SASL_PREP.prepareStored(value);
        }
    }
    ,
    POSTGRESQL_PREPARATION{

        @Override
        char[] doNormalize(char[] value) {
            try {
                return ScramStringFormatting.SASL_PREP.prepareStored(value);
            }
            catch (IllegalArgumentException ex) {
                return value;
            }
        }
    };


    abstract char[] doNormalize(char[] var1);

    public char[] normalize(char[] value) {
        if (null == value || value.length == 0) {
            throw new IllegalArgumentException("Empty string for value");
        }
        char[] normalized = this.doNormalize(value);
        if (null == normalized || normalized.length == 0) {
            throw new IllegalArgumentException("null or empty value after normalization");
        }
        return normalized;
    }
}

