/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.replication.fluent.physical;

import com.vecoo.extralib.shade.postgresql.core.BaseConnection;
import com.vecoo.extralib.shade.postgresql.replication.LogSequenceNumber;
import com.vecoo.extralib.shade.postgresql.replication.ReplicationSlotInfo;
import com.vecoo.extralib.shade.postgresql.replication.ReplicationType;
import com.vecoo.extralib.shade.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.physical.ChainedPhysicalCreateSlotBuilder;
import com.vecoo.extralib.shade.postgresql.util.GT;
import com.vecoo.extralib.shade.postgresql.util.PSQLException;
import com.vecoo.extralib.shade.postgresql.util.PSQLState;
import com.vecoo.extralib.shade.postgresql.util.internal.Nullness;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PhysicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedPhysicalCreateSlotBuilder>
implements ChainedPhysicalCreateSlotBuilder {
    public PhysicalCreateSlotBuilder(BaseConnection connection) {
        super(connection);
    }

    @Override
    protected ChainedPhysicalCreateSlotBuilder self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() throws SQLException {
        ReplicationSlotInfo slotInfo;
        block6: {
            if (this.slotName == null || this.slotName.isEmpty()) {
                throw new IllegalArgumentException("Replication slotName can't be null");
            }
            Statement statement = this.connection.createStatement();
            ResultSet result = null;
            slotInfo = null;
            try {
                String sql = String.format("CREATE_REPLICATION_SLOT %s %s PHYSICAL", this.slotName, this.temporaryOption ? "TEMPORARY" : "");
                statement.execute(sql);
                result = statement.getResultSet();
                if (result != null && result.next()) {
                    slotInfo = new ReplicationSlotInfo(Nullness.castNonNull(result.getString("slot_name")), ReplicationType.PHYSICAL, LogSequenceNumber.valueOf(Nullness.castNonNull(result.getString("consistent_point"))), result.getString("snapshot_name"), result.getString("output_plugin"));
                    break block6;
                }
                throw new PSQLException(GT.tr("{0} returned no results", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            finally {
                if (result != null) {
                    result.close();
                }
                statement.close();
            }
        }
        return slotInfo;
    }
}

