/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.util;

import com.vecoo.extralib.shade.mariadb.jdbc.util.PrepareResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class ClientParser
implements PrepareResult {
    private final String sql;
    private final byte[] query;
    private final List<Integer> paramPositions;
    private final List<Integer> valuesBracketPositions;
    private final int paramCount;
    private final boolean isInsert;
    private final boolean isInsertDuplicate;
    private final boolean isMultiQuery;

    private ClientParser(String sql, byte[] query, List<Integer> paramPositions, List<Integer> valuesBracketPositions, boolean isInsert, boolean isInsertDuplicate, boolean isMultiQuery) {
        this.sql = sql;
        this.query = query;
        this.paramPositions = paramPositions;
        this.valuesBracketPositions = valuesBracketPositions;
        this.paramCount = paramPositions.size();
        this.isInsert = isInsert;
        this.isInsertDuplicate = isInsertDuplicate;
        this.isMultiQuery = isMultiQuery;
    }

    public static ClientParser parameterParts(String queryString, boolean noBackslashEscapes) {
        boolean isMulti;
        ArrayList<Integer> paramPositions = new ArrayList<Integer>(20);
        LexState state = LexState.Normal;
        byte lastChar = 0;
        boolean singleQuotes = false;
        boolean isInsert = false;
        boolean isInsertDuplicate = false;
        int multiQueryIdx = -1;
        byte[] query = queryString.getBytes(StandardCharsets.UTF_8);
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            byte car = query[i];
            if (!(state != LexState.Escape || car == 39 && singleQuotes || car == 34 && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case 42: {
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case 47: {
                    if (state != LexState.SlashStarComment || lastChar != 42) break;
                    state = LexState.Normal;
                    break;
                }
                case 59: {
                    if (state != LexState.Normal || multiQueryIdx != -1) break;
                    multiQueryIdx = i;
                    break;
                }
                case 35: {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 45: {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 10: {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case 34: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 39: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 73: 
                case 105: {
                    if (state != LexState.Normal || isInsert || i + 6 >= queryLength || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)110) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)115) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)101) || !ClientParser.equalsIgnoreCase(query[i + 4], (byte)114) || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)116) || i > 0 && query[i - 1] > 32 && !ClientParser.isDelimiter(query[i - 1]) || query[i + 6] > 32 && !ClientParser.isDelimiter(query[i + 6])) break;
                    i += 5;
                    isInsert = true;
                    break;
                }
                case 68: 
                case 100: {
                    if (!isInsert || state != LexState.Normal || i + 9 >= queryLength || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)117) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)112) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)108) || !ClientParser.equalsIgnoreCase(query[i + 4], (byte)105) || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)99) || !ClientParser.equalsIgnoreCase(query[i + 6], (byte)97) || !ClientParser.equalsIgnoreCase(query[i + 7], (byte)116) || !ClientParser.equalsIgnoreCase(query[i + 8], (byte)101) || i > 0 && query[i - 1] > 32 && !ClientParser.isDelimiter(query[i - 1]) || query[i + 9] > 32 && !ClientParser.isDelimiter(query[i + 9])) break;
                    i += 9;
                    isInsertDuplicate = true;
                    break;
                }
                case 92: {
                    if (state != LexState.String || noBackslashEscapes) break;
                    state = LexState.Escape;
                    break;
                }
                case 63: {
                    if (state != LexState.Normal) break;
                    paramPositions.add(i);
                    break;
                }
                case 96: {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        boolean bl = isMulti = multiQueryIdx != -1 && multiQueryIdx < queryLength - 1;
        if (isMulti) {
            boolean hasAdditionalPart = false;
            for (int i = multiQueryIdx + 1; i < queryLength; ++i) {
                if (ClientParser.isWhitespace(query[i])) continue;
                hasAdditionalPart = true;
                break;
            }
            isMulti = hasAdditionalPart;
        }
        return new ClientParser(queryString, query, paramPositions, null, isInsert, isInsertDuplicate, isMulti);
    }

    public static ClientParser rewritableParts(String queryString, boolean noBackslashEscapes) {
        boolean isMulti;
        boolean reWritablePrepare = true;
        ArrayList<Integer> paramPositions = new ArrayList<Integer>(20);
        ArrayList<Integer> valuesBracketPositions = new ArrayList<Integer>(2);
        LexState state = LexState.Normal;
        byte lastChar = 0;
        boolean singleQuotes = false;
        boolean isInsert = false;
        boolean isInsertDuplicate = false;
        boolean afterValues = false;
        boolean valuesClosed = false;
        int isInParenthesis = 0;
        int multiQueryIdx = -1;
        byte[] query = queryString.getBytes(StandardCharsets.UTF_8);
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            byte car = query[i];
            if (!(state != LexState.Escape || car == 39 && singleQuotes || car == 34 && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case 42: {
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case 47: {
                    if (state != LexState.SlashStarComment || lastChar != 42) break;
                    state = LexState.Normal;
                    break;
                }
                case 59: {
                    if (state != LexState.Normal || multiQueryIdx != -1) break;
                    multiQueryIdx = i;
                    break;
                }
                case 35: {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 45: {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 10: {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case 34: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 39: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 73: 
                case 105: {
                    if (state != LexState.Normal || isInsert || i + 6 >= queryLength || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)110) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)115) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)101) || !ClientParser.equalsIgnoreCase(query[i + 4], (byte)114) || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)116) || i > 0 && query[i - 1] > 32 && !ClientParser.isDelimiter(query[i - 1]) || query[i + 6] > 32 && !ClientParser.isDelimiter(query[i + 6])) break;
                    i += 5;
                    isInsert = true;
                    break;
                }
                case 68: 
                case 100: {
                    if (!isInsert || state != LexState.Normal || i + 9 >= queryLength || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)117) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)112) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)108) || !ClientParser.equalsIgnoreCase(query[i + 4], (byte)105) || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)99) || !ClientParser.equalsIgnoreCase(query[i + 6], (byte)97) || !ClientParser.equalsIgnoreCase(query[i + 7], (byte)116) || !ClientParser.equalsIgnoreCase(query[i + 8], (byte)101) || i > 0 && query[i - 1] > 32 && !ClientParser.isDelimiter(query[i - 1]) || query[i + 9] > 32 && !ClientParser.isDelimiter(query[i + 9])) break;
                    i += 9;
                    isInsertDuplicate = true;
                    break;
                }
                case 83: 
                case 115: {
                    if (state != LexState.Normal || valuesBracketPositions.isEmpty() || queryLength <= i + 7 || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)101) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)108) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)101) || !ClientParser.equalsIgnoreCase(query[i + 4], (byte)99) || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)116) || i > 0 && query[i - 1] > 32 && !ClientParser.isDelimiter(query[i - 1]) || query[i + 6] > 32 && !ClientParser.isDelimiter(query[i + 6])) break;
                    reWritablePrepare = false;
                    break;
                }
                case 86: 
                case 118: {
                    if (state != LexState.Normal || !valuesBracketPositions.isEmpty() || lastChar != 41 && lastChar > 40 || queryLength <= i + 7 || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)97) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)108) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)117) || !ClientParser.equalsIgnoreCase(query[i + 4], (byte)101) || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)115) || query[i + 6] != 40 && query[i + 6] > 40) break;
                    afterValues = true;
                    if (query[i + 6] == 40) {
                        valuesBracketPositions.add(i + 6);
                    }
                    i += 5;
                    break;
                }
                case 76: 
                case 108: {
                    if (state != LexState.Normal || queryLength <= i + 14 || !ClientParser.equalsIgnoreCase(query[i + 1], (byte)97) || !ClientParser.equalsIgnoreCase(query[i + 2], (byte)115) || !ClientParser.equalsIgnoreCase(query[i + 3], (byte)116) || query[i + 4] != 95 || !ClientParser.equalsIgnoreCase(query[i + 5], (byte)105) || !ClientParser.equalsIgnoreCase(query[i + 6], (byte)110) || !ClientParser.equalsIgnoreCase(query[i + 7], (byte)115) || !ClientParser.equalsIgnoreCase(query[i + 8], (byte)101) || !ClientParser.equalsIgnoreCase(query[i + 9], (byte)114) || !ClientParser.equalsIgnoreCase(query[i + 10], (byte)116) || query[i + 11] != 95 || !ClientParser.equalsIgnoreCase(query[i + 12], (byte)105) || !ClientParser.equalsIgnoreCase(query[i + 13], (byte)100) || query[i + 14] != 40) break;
                    reWritablePrepare = false;
                    break;
                }
                case 40: {
                    if (state != LexState.Normal) break;
                    ++isInParenthesis;
                    if (!afterValues || !valuesBracketPositions.isEmpty()) break;
                    valuesBracketPositions.add(i);
                    break;
                }
                case 92: {
                    if (state != LexState.String || noBackslashEscapes) break;
                    state = LexState.Escape;
                    break;
                }
                case 41: {
                    if (state != LexState.Normal || !afterValues || valuesClosed || --isInParenthesis != 0 || valuesBracketPositions.size() != 1) break;
                    int j = i + 1;
                    while (j < queryLength) {
                        byte c = query[j];
                        if (ClientParser.isWhitespace(c)) {
                            ++j;
                            continue;
                        }
                        if (c == 35) {
                            ++j;
                            while (j < queryLength && query[j] != 10) {
                                ++j;
                            }
                            continue;
                        }
                        if (c == 45 && j + 1 < queryLength && query[j + 1] == 45) {
                            j += 2;
                            while (j < queryLength && query[j] != 10) {
                                ++j;
                            }
                            continue;
                        }
                        if (c != 47 || j + 1 >= queryLength || query[j + 1] != 42) break;
                        j += 2;
                        while (j + 1 < queryLength && (query[j] != 42 || query[j + 1] != 47)) {
                            ++j;
                        }
                        j = Math.min(j + 2, queryLength);
                    }
                    if (j < queryLength && query[j] == 44) break;
                    valuesBracketPositions.add(i);
                    valuesClosed = true;
                    break;
                }
                case 63: {
                    if (state != LexState.Normal) break;
                    paramPositions.add(i);
                    if (!valuesClosed) break;
                    reWritablePrepare = false;
                    break;
                }
                case 96: {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        boolean bl = isMulti = multiQueryIdx != -1 && multiQueryIdx < queryLength - 1;
        if (isMulti) {
            boolean hasAdditionalPart = false;
            for (int i = multiQueryIdx + 1; i < queryLength; ++i) {
                byte car = query[i];
                if (car == 32 || car == 10 || car == 13 || car == 9) continue;
                hasAdditionalPart = true;
                break;
            }
            isMulti = hasAdditionalPart;
        }
        if (isMulti || !isInsert || !reWritablePrepare || valuesBracketPositions.size() != 2) {
            valuesBracketPositions = null;
        }
        return new ClientParser(queryString, query, paramPositions, valuesBracketPositions, isInsert, isInsertDuplicate, isMulti);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public byte[] getQuery() {
        return this.query;
    }

    public List<Integer> getParamPositions() {
        return this.paramPositions;
    }

    public List<Integer> getValuesBracketPositions() {
        return this.valuesBracketPositions;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public boolean isInsert() {
        return this.isInsert;
    }

    public boolean isInsertDuplicate() {
        return this.isInsertDuplicate;
    }

    public boolean isMultiQuery() {
        return this.isMultiQuery;
    }

    private static boolean isDelimiter(byte b) {
        return b == 40 || b == 41 || b == 59 || b == 62 || b == 60 || b == 61 || b == 45 || b == 43 || b == 44;
    }

    private static boolean isWhitespace(byte b) {
        return b == 32 || b == 10 || b == 13 || b == 9;
    }

    private static boolean equalsIgnoreCase(byte b, byte lower) {
        return (b | 0x20) == lower;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

