/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.addon;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.impl.StandardReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Reader;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Writer;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.AuthenticationPlugin;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.addon.gssapi.GssUtility;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.addon.gssapi.GssapiAuth;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.addon.gssapi.StandardGssapiAuthentication;
import java.io.IOException;
import java.sql.SQLException;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private final byte[] seed;
    private final String optionServicePrincipalName;

    public SendGssApiAuthPacket(byte[] seed, Configuration conf) {
        this.seed = seed;
        this.optionServicePrincipalName = conf.servicePrincipalName();
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context, boolean sslFingerPrintValidation) throws IOException, SQLException {
        StandardReadableByteBuf buf = new StandardReadableByteBuf(this.seed, this.seed.length);
        String serverSpn = buf.readStringNullEnd();
        String servicePrincipalName = this.optionServicePrincipalName != null ? this.optionServicePrincipalName : serverSpn;
        String mechanisms = buf.readStringNullEnd();
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(out, in, servicePrincipalName, mechanisms);
        return in.readReusablePacket();
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t2) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

