/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.lucko.fabric.api.permissions.v0;

import com.mojang.authlib.GameProfile;
import com.vecoo.extralib.shade.lucko.fabric.api.permissions.v0.OfflineOptionRequestEvent;
import com.vecoo.extralib.shade.lucko.fabric.api.permissions.v0.OptionRequestEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2172;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Options {
    @NotNull
    public static Optional<String> get(@NotNull class_2172 source, @NotNull String key) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(key, "key");
        return ((OptionRequestEvent)OptionRequestEvent.EVENT.invoker()).onOptionRequest(source, key);
    }

    @Contract(value="_, _, !null -> !null")
    public static String get(@NotNull class_2172 source, @NotNull String key, String defaultValue) {
        return Options.get(source, key).orElse(defaultValue);
    }

    @NotNull
    public static <T> Optional<T> get(@NotNull class_2172 source, @NotNull String key, @NotNull Function<String, ? extends T> valueTransformer) {
        return Options.get(source, key).flatMap(value -> {
            try {
                return Optional.ofNullable(valueTransformer.apply((String)value));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    @Contract(value="_, _, !null, _ -> !null")
    public static <T> T get(@NotNull class_2172 source, @NotNull String key, T defaultValue, @NotNull Function<String, ? extends T> valueTransformer) {
        return Options.get(source, key, valueTransformer).orElse(defaultValue);
    }

    @NotNull
    public static Optional<String> get(@NotNull class_1297 entity, @NotNull String key) {
        Objects.requireNonNull(entity, "entity");
        return Options.get((class_2172)entity.method_5671(), key);
    }

    @Contract(value="_, _, !null -> !null")
    public static String get(@NotNull class_1297 entity, @NotNull String key, String defaultValue) {
        Objects.requireNonNull(entity, "entity");
        return Options.get((class_2172)entity.method_5671(), key, defaultValue);
    }

    @NotNull
    public static <T> Optional<T> get(@NotNull class_1297 entity, @NotNull String key, @NotNull Function<String, ? extends T> valueTransformer) {
        Objects.requireNonNull(entity, "entity");
        return Options.get((class_2172)entity.method_5671(), key, valueTransformer);
    }

    @Contract(value="_, _, !null, _ -> !null")
    public static <T> T get(@NotNull class_1297 entity, @NotNull String key, T defaultValue, @NotNull Function<String, ? extends T> valueTransformer) {
        Objects.requireNonNull(entity, "entity");
        return Options.get((class_2172)entity.method_5671(), key, defaultValue, valueTransformer);
    }

    @NotNull
    public static CompletableFuture<Optional<String>> get(@NotNull UUID uuid, @NotNull String key) {
        Objects.requireNonNull(uuid, "uuid");
        Objects.requireNonNull(key, "key");
        return ((OfflineOptionRequestEvent)OfflineOptionRequestEvent.EVENT.invoker()).onOptionRequest(uuid, key);
    }

    @Contract(value="_, _, !null -> !null")
    public static CompletableFuture<String> get(@NotNull UUID uuid, @NotNull String key, String defaultValue) {
        return Options.get(uuid, key).thenApply(opt -> opt.orElse(defaultValue));
    }

    @NotNull
    public static <T> CompletableFuture<Optional<T>> get(@NotNull UUID uuid, @NotNull String key, @NotNull Function<String, ? extends T> valueTransformer) {
        return Options.get(uuid, key).thenApply(opt -> opt.flatMap(value -> {
            try {
                return Optional.ofNullable(valueTransformer.apply((String)value));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }));
    }

    @Contract(value="_, _, !null, _ -> !null")
    public static <T> CompletableFuture<T> get(@NotNull UUID uuid, @NotNull String key, T defaultValue, @NotNull Function<String, ? extends T> valueTransformer) {
        return Options.get(uuid, key, valueTransformer).thenApply(opt -> opt.orElse(defaultValue));
    }

    @NotNull
    public static CompletableFuture<Optional<String>> get(@NotNull GameProfile profile, @NotNull String key) {
        Objects.requireNonNull(profile, "profile");
        return Options.get(profile.getId(), key);
    }

    @Contract(value="_, _, !null -> !null")
    public static CompletableFuture<String> get(@NotNull GameProfile profile, @NotNull String key, String defaultValue) {
        Objects.requireNonNull(profile, "profile");
        return Options.get(profile.getId(), key, defaultValue);
    }

    @NotNull
    public static <T> CompletableFuture<Optional<T>> get(@NotNull GameProfile profile, @NotNull String key, @NotNull Function<String, ? extends T> valueTransformer) {
        Objects.requireNonNull(profile, "profile");
        return Options.get(profile.getId(), key, valueTransformer);
    }

    @Contract(value="_, _, !null, _ -> !null")
    public static <T> CompletableFuture<T> get(@NotNull GameProfile profile, @NotNull String key, T defaultValue, @NotNull Function<String, ? extends T> valueTransformer) {
        Objects.requireNonNull(profile, "profile");
        return Options.get(profile.getId(), key, defaultValue, valueTransformer);
    }
}

