/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.config;

import com.vecoo.extralib.shade.spongepowered.configurate.CommentedConfigurationNode;
import com.vecoo.extralib.shade.spongepowered.configurate.objectmapping.ObjectMapper;
import com.vecoo.extralib.shade.spongepowered.configurate.yaml.NodeStyle;
import com.vecoo.extralib.shade.spongepowered.configurate.yaml.YamlConfigurationLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public final class YamlConfigFactory {
    private YamlConfigFactory() {
    }

    public static <T> T load(@NotNull Class<T> clazz, @NotNull String path) {
        return YamlConfigFactory.load(clazz, Paths.get(path, new String[0]));
    }

    public static <T> T load(@NotNull Class<T> clazz, @NotNull Path path) {
        try {
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).nodeStyle(NodeStyle.BLOCK).build();
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
            ObjectMapper<T> mapper = ObjectMapper.factory().get(clazz);
            T config = mapper.load(root);
            mapper.save(config, root);
            loader.save(root);
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to load config: %s", path), e);
        }
    }
}

