/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import link.infra.indium.mixin.sodium.AccessBlockRenderer;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.accessor.AccessBlockRenderCache;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.AbstractBlockRenderContext;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import me.jellysquid.mods.sodium.client.model.light.data.ArrayLightDataCache;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5539;
import net.minecraft.class_6575;
import org.joml.Vector3fc;

public class TerrainRenderContext
extends AbstractBlockRenderContext {
    private final ArrayLightDataCache lightCache;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private ChunkBuildBuffers buffers;
    private Vector3fc origin;
    private class_243 modelOffset;

    public TerrainRenderContext(BlockRenderCache renderCache) {
        WorldSlice worldSlice = renderCache.getWorldSlice();
        BlockOcclusionCache blockOcclusionCache = ((AccessBlockRenderer)renderCache.getBlockRenderer()).indium$occlusionCache();
        this.lightCache = ((AccessBlockRenderCache)renderCache).indium$getLightDataCache();
        this.blockInfo = new TerrainBlockRenderInfo(blockOcclusionCache);
        this.blockInfo.random = new class_6575(42L);
        this.blockInfo.prepareForWorld((class_1920)worldSlice, true);
        this.aoCalc = new AoCalculator(this.blockInfo, (LightDataAccess)this.lightCache);
    }

    public static TerrainRenderContext get(ChunkBuildContext buildContext) {
        return ((AccessBlockRenderCache)buildContext.cache).indium$getTerrainRenderContext();
    }

    @Override
    protected LightDataAccess getLightCache() {
        return this.lightCache;
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad, Material material) {
        Vector3fc origin = this.origin;
        class_243 modelOffset = this.modelOffset;
        ModelQuadOrientation orientation = quad.orientation();
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = origin.x() + quad.x(srcIndex) + (float)modelOffset.method_10216();
            out.y = origin.y() + quad.y(srcIndex) + (float)modelOffset.method_10214();
            out.z = origin.z() + quad.z(srcIndex) + (float)modelOffset.method_10215();
            int color = quad.color(srcIndex);
            out.color = ColorARGB.toABGR((int)color, (int)(color >>> 24 & 0xFF));
            out.u = quad.u(srcIndex);
            out.v = quad.v(srcIndex);
            out.light = quad.lightmap(srcIndex);
        }
        ChunkModelBuilder builder = this.buffers.get(material);
        ModelQuadFacing normalFace = quad.normalFace();
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
        class_1058 sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find((QuadView)quad);
        }
        builder.addSprite(sprite);
    }

    @Override
    protected void shadeQuad(MutableQuadViewImpl quad, boolean isVanilla, boolean ao, boolean emissive) {
        super.shadeQuad(quad, isVanilla, ao, emissive);
        if (ao) {
            quad.orientation(ModelQuadOrientation.orientByBrightness((float[])this.aoCalc.ao, (int[])this.aoCalc.light));
        } else {
            quad.orientation(ModelQuadOrientation.NORMAL);
        }
    }

    public void prepare(ChunkBuildContext buildContext) {
        this.buffers = buildContext.buffers;
    }

    public void release() {
        this.blockInfo.releaseBlock();
        this.buffers = null;
    }

    public void tessellateBlock(BlockRenderContext ctx) {
        try {
            this.origin = ctx.origin();
            this.modelOffset = ctx.state().method_26226((class_1922)ctx.world(), ctx.pos());
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(ctx.state(), ctx.pos(), ctx.seed(), ctx.model().method_4708());
            ctx.model().emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in world - Indium Renderer");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)ctx.world(), (class_2338)ctx.pos(), (class_2680)ctx.state());
            throw new class_148(crashReport);
        }
    }
}

