/*
 * Decompiled with CFR 0.152.
 */
package de.tyrannus.cleandebug;

import de.tyrannus.cleandebug.CleanDebugConfig;
import de.tyrannus.cleandebug.HardwareMode;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_3965;

public class CleanDebug
implements ClientModInitializer {
    public void onInitializeClient() {
        MidnightConfig.init((String)"clean-debug", CleanDebugConfig.class);
    }

    public static void modifyLeftText(List<String> text) {
        int coordIndex;
        text.removeIf(Objects::isNull);
        if (CleanDebugConfig.hideActiveRenderer) {
            text.removeIf(s -> s.startsWith("[Fabric] Active renderer:"));
        }
        if (CleanDebugConfig.hideDebugHints) {
            text.removeIf(s -> s.contains("Debug: Pie"));
        }
        if (CleanDebugConfig.hideHelpShortcut) {
            text.removeIf(s -> s.equals("For help: press F3 + Q"));
            text.removeIf(s -> s.startsWith("Debug charts:"));
        }
        if (CleanDebugConfig.hideNoiseRouter) {
            text.removeIf(s -> s.startsWith("NoiseRouter"));
        }
        if (CleanDebugConfig.onlyShowNecessary) {
            text.removeIf(s -> s.startsWith("Chunks[") || s.startsWith("Block: ") || s.startsWith("Chunk: ") || s.startsWith("CH S:") || s.startsWith("SH S:") || s.startsWith("SC: ") || s.startsWith("Sounds: ") || s.startsWith("Blending: "));
        }
        if (CleanDebugConfig.hideIris) {
            text.removeIf(s -> s.startsWith("[Iris]"));
            text.removeIf(s -> s.startsWith("[Entity Batching]"));
        }
        if (CleanDebugConfig.hideLitematica) {
            text.removeIf(s -> s.startsWith("\u00a76[Litematica]\u00a7r"));
        }
        if (CleanDebugConfig.hideEntityCulling) {
            text.removeIf(s -> s.startsWith("[Culling]"));
        }
        if (CleanDebugConfig.hideViaFabric) {
            text.removeIf(s -> s.startsWith("[ViaFabric]"));
        }
        if (CleanDebugConfig.hideJourneyMap) {
            text.removeIf(s -> s.startsWith("\u00a7b[JM]"));
        }
        if (CleanDebugConfig.hideLambDynamicLights) {
            text.removeIf(s -> s.startsWith("Dynamic Light Sources: ") || s.startsWith("\u00a7d[LDL]"));
        }
        if (CleanDebugConfig.hideDynamicFps) {
            text.removeIf(s -> s.startsWith("\u00a7c[Dynamic FPS] "));
        }
        if (CleanDebugConfig.hideCoordinates && (coordIndex = CleanDebug.indexOfStartingWith(text, "XYZ: ")) != -1) {
            text.remove(coordIndex);
            text.add(coordIndex, "XYZ: Hidden by CleanF3");
            text.removeIf(s -> s.startsWith("Block: "));
            text.removeIf(s -> s.startsWith("Chunk: "));
        }
    }

    public static void modifyRightText(List<String> text) {
        int figuraIndex;
        int caveDustIndex;
        int modernFixIndex;
        int cpuIndex;
        text.removeIf(Objects::isNull);
        if (CleanDebugConfig.hardwareMode == HardwareMode.NONE) {
            text.removeIf(s -> s.startsWith("Java:"));
            text.removeIf(s -> s.startsWith("Mem:"));
            text.removeIf(s -> s.startsWith("Allocation rate:"));
            text.removeIf(s -> s.startsWith("Allocated:"));
            text.removeIf(s -> s.startsWith("Off-Heap:"));
            text.removeIf(s -> s.startsWith("Direct Buffers:"));
            if (!text.isEmpty() && text.get(0).isEmpty()) {
                text.remove(0);
            }
        }
        if (CleanDebugConfig.hardwareMode != HardwareMode.ALL && (cpuIndex = CleanDebug.indexOfStartingWith(text, "CPU: ")) != -1) {
            text.subList(cpuIndex, Math.min(cpuIndex + 6, text.size())).clear();
        }
        if (CleanDebugConfig.hideTags) {
            text.removeIf(s -> s.startsWith("#"));
        }
        if (CleanDebugConfig.hideSodium) {
            int sodiumIndex = CleanDebug.indexOfStartingWith(text, "\u00a7aSodium Renderer");
            if (sodiumIndex != -1) {
                text.subList(sodiumIndex, Math.min(sodiumIndex + 7, text.size())).clear();
                if (sodiumIndex > 0 && text.get(sodiumIndex - 1).isEmpty()) {
                    text.remove(sodiumIndex - 1);
                }
            } else {
                sodiumIndex = CleanDebug.indexOfStartingWith(text, "Sodium Renderer");
                if (sodiumIndex != -1) {
                    text.remove(sodiumIndex);
                }
            }
        }
        if (CleanDebugConfig.hideIris) {
            text.removeIf(s -> s.startsWith("[Iris]"));
        }
        if (CleanDebugConfig.hideModernFix && (modernFixIndex = CleanDebug.indexOfStartingWith(text, "ModernFix")) != -1) {
            text.subList(modernFixIndex, Math.min(modernFixIndex + 2, text.size())).clear();
        }
        if (CleanDebugConfig.hideCaveDust && (caveDustIndex = CleanDebug.indexOfStartingWith(text, "Particle amount evaluated: ")) != -1) {
            text.remove(caveDustIndex);
            if (caveDustIndex > 0 && text.get(caveDustIndex - 1).isEmpty()) {
                text.remove(caveDustIndex - 1);
            }
            if (caveDustIndex < text.size() && text.get(caveDustIndex).isEmpty()) {
                text.remove(caveDustIndex);
            }
        }
        if (CleanDebugConfig.hideFigura && (figuraIndex = CleanDebug.indexOfStartingWith(text, "\u00a7b[Figura]")) != -1) {
            int figuraEndIndex = CleanDebug.indexOfStartingWith(text, "Pings per second:");
            text.subList(figuraIndex, figuraEndIndex + 1).clear();
            if (figuraIndex > 0) {
                text.remove(figuraIndex - 1);
            }
        }
        if (CleanDebugConfig.hideCoordinates) {
            text.removeIf(s -> s.startsWith(class_124.field_1073 + "Targeted Block: "));
        }
        while (!text.isEmpty() && text.get(0).isEmpty()) {
            text.remove(0);
        }
    }

    public static class_239.class_240 getFluidHitResultType(class_239 result, class_1937 world) {
        class_3965 blockHitResult;
        if (CleanDebugConfig.shyFluids && result instanceof class_3965 && world.method_8316((blockHitResult = (class_3965)result).method_17777()).method_15769()) {
            return class_239.class_240.field_1333;
        }
        return result.method_17783();
    }

    private static int indexOfStartingWith(List<String> list, String startingWith) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!(startingWith.isEmpty() ? string.isEmpty() : string.startsWith(startingWith))) continue;
            return i;
        }
        return -1;
    }
}

