/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.holder.ManualSyncing;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.fabric.fluid.storage.SingleFluidSlot;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricBlockFluidContainer<T extends FluidContainer & Updatable<class_2586>>
extends ExtendedFluidContainer
implements Storage<FluidVariant>,
ManualSyncing {
    protected final T container;
    protected final class_2586 entity;

    public FabricBlockFluidContainer(T container, class_2586 entity) {
        this.container = container;
        this.entity = entity;
    }

    public boolean supportsInsertion() {
        return this.container.allowsInsertion();
    }

    public boolean supportsExtraction() {
        return this.container.allowsExtraction();
    }

    public long simulateInsert(FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), true);
    }

    public long simulateExtract(FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), true).getFluidAmount();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        return IntStream.range(0, this.container.getSize()).mapToObj(index -> new SingleFluidSlot(this, index)).map(holder -> holder).iterator();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        ((Updatable)this.container).update(this.entity);
    }
}

