/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5270;

public class ServerResourceData {
    private static final Multimap<TableChecker, class_52> DIRECT_DROPS = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    public static final List<class_2960> SHEEP_TABLES;
    public static final List<TableChecker> TABLE_EXCLUSIONS;
    private static final Gson GSON;
    private static final int DIRECT_DROPS_PATH_LENGTH;
    private static final int FILE_SUFFIX_LENGTH;

    public static void loadDirectTables(class_3300 resourceManager) {
        DIRECT_DROPS.clear();
        resourceManager.method_14488("direct_drops", path -> path.method_12832().endsWith(".json")).forEach(ServerResourceData::loadDirectTable);
        resourceManager.method_14488("emi_loot_data", path -> path.method_12832().endsWith(".json")).forEach(ServerResourceData::loadTableExclusion);
    }

    private static void loadDirectTable(class_2960 id, class_3298 resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading direct drop table from file: {}", (Object)id.toString());
        }
        String path = id.method_12832();
        class_2960 id2 = new class_2960(id.method_12836(), path.substring(DIRECT_DROPS_PATH_LENGTH, path.length() - FILE_SUFFIX_LENGTH));
        String path2 = id2.method_12832();
        if (!(path2.startsWith("blocks/") || path2.startsWith("entities/") || path2.startsWith("chests/"))) {
            EMILoot.LOGGER.error("File path for [{}] not correct; needs a 'blocks', 'entities' or 'chests' subfolder. Skipping.", (Object)id);
            EMILoot.LOGGER.error("Example: [./data/mod_id/direct_drops/blocks/cobblestone.json] is a valid block direct drop table path for a block added by [mod_id].");
            return;
        }
        try {
            BufferedReader reader = resource.method_43039();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            TableChecker checker = ServerResourceData.loadTableCheckerFromTable(id2, json);
            class_52 lootTable = EMILootAgnos.loadLootTable(GSON, id2, json);
            if (lootTable != null) {
                DIRECT_DROPS.put((Object)checker, (Object)lootTable);
            } else {
                EMILoot.LOGGER.error("Loot table in file [{}] is empty!", (Object)id);
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read direct drops loot table file: {}", (Object)id);
        }
    }

    private static TableChecker loadTableCheckerFromTable(class_2960 id, JsonObject jsonObject) {
        if (!jsonObject.has("match_tables")) {
            return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
        }
        JsonElement matchesElement = jsonObject.get("match_tables");
        if (!matchesElement.isJsonObject()) {
            EMILoot.LOGGER.error("Direct drops table {} has malformed table matcher, needs to be an object", (Object)id);
            return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
        }
        JsonObject matchesObject = matchesElement.getAsJsonObject();
        return ServerResourceData.loadTableChecker(id, jsonObject, "Direct drops table");
    }

    private static TableChecker loadTableChecker(class_2960 id, JsonObject matchesObject, String messagePrefix) {
        Optional<Pattern> regexCheck = Optional.empty();
        if (matchesObject.has("regex")) {
            JsonElement regexElement = matchesObject.get("regex");
            if (!regexElement.isJsonPrimitive()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'regex' key needs a primitive string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            JsonPrimitive regexPrimitive = regexElement.getAsJsonPrimitive();
            if (!regexPrimitive.isString()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'regex' key needs a string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            regexCheck = Optional.of(Pattern.compile(regexPrimitive.getAsString()));
        }
        Optional<List<class_2960>> idsCheck = Optional.empty();
        if (matchesObject.has("ids")) {
            JsonElement idsElement = matchesObject.get("ids");
            if (!idsElement.isJsonArray()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'ids' key needs to be an array of strings", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            JsonArray idsArray = idsElement.getAsJsonArray();
            ArrayList<class_2960> ids = new ArrayList<class_2960>();
            for (int i = 0; i < idsArray.size(); ++i) {
                JsonElement idElement = idsArray.get(i);
                if (!idElement.isJsonPrimitive()) {
                    EMILoot.LOGGER.error("{} {} has malformed table matcher. 'id' key has non-primitive-string value at index {}", new Object[]{messagePrefix, id, i});
                    return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
                }
                JsonPrimitive idPrimitive = idElement.getAsJsonPrimitive();
                if (!idPrimitive.isString()) {
                    EMILoot.LOGGER.error("{} {} has malformed table matcher. 'id' key has non-string value at index {}", new Object[]{messagePrefix, id, i});
                    return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
                }
                class_2960 idsId = class_2960.method_12829((String)idPrimitive.getAsString());
                if (idsId == null) {
                    EMILoot.LOGGER.error("{} {} has malformed table matcher. 'id' key has unparsable identifier {} at index {}", new Object[]{messagePrefix, id, idPrimitive.getAsString(), i});
                    return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
                }
                ids.add(idsId);
            }
            idsCheck = Optional.of(ids);
        }
        Optional<class_176> typeCheck = Optional.empty();
        if (matchesObject.has("type")) {
            JsonElement typeElement = matchesObject.get("type");
            if (!typeElement.isJsonPrimitive()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key needs a primitive string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            JsonPrimitive typePrimitive = typeElement.getAsJsonPrimitive();
            if (!typePrimitive.isString()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key needs a string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            class_2960 typeId = class_2960.method_12829((String)typePrimitive.getAsString());
            if (typeId == null) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key has unparsable identifier {}", new Object[]{messagePrefix, id, typePrimitive.getAsString()});
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            class_176 type = class_173.method_757((class_2960)typeId);
            if (type == null) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key has unregistered context type {}", new Object[]{messagePrefix, id, typeId});
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            typeCheck = Optional.of(type);
        }
        return new TableChecker(id, regexCheck, idsCheck, typeCheck);
    }

    private static void loadTableExclusion(class_2960 id, class_3298 resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading exclusion table from file: {}", (Object)id.toString());
        }
        try {
            BufferedReader reader = resource.method_43039();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonElement list = json.get("exclusions");
            if (list != null && list.isJsonArray()) {
                for (JsonElement element : list.getAsJsonArray()) {
                    if (element.isJsonPrimitive()) {
                        class_2960 identifier = new class_2960(element.getAsString());
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding exclusion: {}", (Object)identifier);
                        }
                        TABLE_EXCLUSIONS.add(new TableChecker(identifier, Optional.empty(), Optional.empty(), Optional.empty()));
                        continue;
                    }
                    if (element.isJsonObject()) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding complex exclusion: {}", (Object)element);
                        }
                        TABLE_EXCLUSIONS.add(ServerResourceData.loadTableChecker(id, element.getAsJsonObject(), "Table exclusion"));
                        continue;
                    }
                    EMILoot.LOGGER.error("Exclusion element not properly formatted: {}", (Object)element);
                }
            } else {
                EMILoot.LOGGER.error("Exclusions in file: {} not readable.", (Object)id);
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read table exclusions file: {}", (Object)id);
        }
    }

    public static boolean skipTable(class_52 table, class_2960 id) {
        for (TableChecker checker : TABLE_EXCLUSIONS) {
            if (!checker.check(table, id)) continue;
            return true;
        }
        return false;
    }

    public static List<class_52> getDirectTables(class_52 table, class_2960 id, boolean getDirect) {
        if (!getDirect) {
            return List.of();
        }
        ArrayList<class_52> tables = new ArrayList<class_52>();
        for (TableChecker checker : DIRECT_DROPS.keySet()) {
            if (!checker.check(table, id)) continue;
            Collection checkedTables = DIRECT_DROPS.get((Object)checker);
            tables.addAll(checkedTables);
        }
        return tables;
    }

    public static Multimap<class_2960, class_52> getMissedDirectDrops(List<class_2960> parsedList) {
        Multimap missedDrops = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Map.Entry entry : DIRECT_DROPS.entries()) {
            if (((TableChecker)entry.getKey()).isComplex() || parsedList.contains(((TableChecker)entry.getKey()).idCheck())) continue;
            missedDrops.put((Object)((TableChecker)entry.getKey()).idCheck(), (Object)((class_52)entry.getValue()));
        }
        return missedDrops;
    }

    static {
        TABLE_EXCLUSIONS = new LinkedList<TableChecker>();
        GSON = class_5270.method_27862().create();
        DIRECT_DROPS_PATH_LENGTH = "direct_drops/".length();
        FILE_SUFFIX_LENGTH = ".json".length();
        class_2960[] ids = new class_2960[]{class_39.field_869, class_39.field_814, class_39.field_224, class_39.field_461, class_39.field_385, class_39.field_702, class_39.field_629, class_39.field_878, class_39.field_806, class_39.field_365, class_39.field_285, class_39.field_394, class_39.field_489, class_39.field_607, class_39.field_716, class_39.field_778};
        SHEEP_TABLES = Arrays.stream(ids).toList();
    }

    private record TableChecker(class_2960 idCheck, Optional<Pattern> regexCheck, Optional<List<class_2960>> idsCheck, Optional<class_176> typeCheck) {
        boolean check(class_52 table, class_2960 id) {
            if (this.idCheck.equals((Object)id)) {
                return true;
            }
            if (this.regexCheck.map(regex -> regex.matcher(id.toString()).find()).orElse(false).booleanValue()) {
                return true;
            }
            if (this.idsCheck.map(ids -> ids.contains(id)).orElse(false).booleanValue()) {
                return true;
            }
            return this.typeCheck.map(type -> type.equals(table.method_322())).orElse(false);
        }

        boolean isComplex() {
            return this.regexCheck.isPresent() || this.idsCheck.isPresent() || this.typeCheck.isPresent();
        }
    }
}

