/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.utils.asm;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\u001a\u0011\u0010\u0001\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u001b\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0015\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0015\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\u0002\"#\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"", "descriptorToClassName", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/lang/ClassLoader;", "className", "", "getClassByteArray", "(Ljava/lang/ClassLoader;Ljava/lang/String;)[B", "Ljava/io/InputStream;", "stream", "readStream", "(Ljava/io/InputStream;)[B", "name", "classFileFromName", "Lorg/objectweb/asm/tree/AnnotationNode;", "", "", "getMappedValues", "(Lorg/objectweb/asm/tree/AnnotationNode;)Ljava/util/Map;", "mappedValues", "cynosure_fabric"})
@SourceDebugExtension(value={"SMAP\nASMUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASMUtils.kt\ndev/mayaqq/cynosure/utils/asm/ASMUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1878#2,3:62\n1#3:65\n*S KotlinDebug\n*F\n+ 1 ASMUtils.kt\ndev/mayaqq/cynosure/utils/asm/ASMUtilsKt\n*L\n14#1:62,3\n*E\n"})
public final class ASMUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> getMappedValues(@NotNull AnnotationNode $this$mappedValues) {
        Map map2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$mappedValues, (String)"<this>");
            map2 = new LinkedHashMap();
            List list = $this$mappedValues.values;
            if (list == null) break block2;
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int index = n;
                boolean i = false;
                if (index % 2 != 0) continue;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                map2.put((String)value, $this$mappedValues.values.get(index + 1));
            }
        }
        return map2;
    }

    @NotNull
    public static final String descriptorToClassName(@NotNull String $this$descriptorToClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$descriptorToClassName, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)$this$descriptorToClassName, (char)'L', null, (int)2, null), (char)';', null, (int)2, null), (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] getClassByteArray(@NotNull ClassLoader $this$getClassByteArray, @NotNull String className) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$getClassByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Object object = $this$getClassByteArray.getResource(ASMUtilsKt.classFileFromName(className));
        if (object != null && (object = ((URL)object).openStream()) != null) {
            Closeable closeable = (Closeable)object;
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean j = false;
                int a = inputStream.available();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(a < 32 ? 32768 : a);
                byte[] buffer = new byte[8192];
                int len = 0;
                while (true) {
                    int n;
                    int it = n = inputStream.read(buffer);
                    boolean i = false;
                    len = it;
                    if (n <= 0) break;
                    outputStream.write(buffer, 0, len);
                }
                byte[] byArray2 = outputStream.toByteArray();
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    @NotNull
    public static final byte[] readStream(@NotNull InputStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int nRead = 0;
        byte[] data = new byte[16384];
        while (true) {
            int n;
            int it = n = stream.read(data, 0, data.length);
            boolean i = false;
            nRead = it;
            if (n == -1) break;
            buffer.write(data, 0, nRead);
        }
        stream.close();
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public static final String classFileFromName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
    }
}

