/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.core;

import dev.mayaqq.cynosure.core.Environment;
import dev.mayaqq.cynosure.core.GameInstance;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.minecraft.class_1255;
import net.minecraft.class_310;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u001f\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00048V@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/mayaqq/cynosure/core/GameInstanceImpl;", "Ldev/mayaqq/cynosure/core/GameInstance;", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "onLoadServer", "(Lnet/minecraft/server/MinecraftServer;)V", "onUnloadServer", "Ldev/mayaqq/cynosure/core/Environment;", "side", "Lnet/minecraft/class_1255;", "Lnet/minecraft/class_3738;", "getEventLoop", "(Ldev/mayaqq/cynosure/core/Environment;)Lnet/minecraft/class_1255;", "", "className", "", "getClassBytes", "(Ljava/lang/String;)[B", "value", "currentServer", "Lnet/minecraft/server/MinecraftServer;", "getCurrentServer", "()Lnet/minecraft/server/MinecraftServer;", "cynosure_fabric"})
public final class GameInstanceImpl
implements GameInstance {
    @NotNull
    public static final GameInstanceImpl INSTANCE = new GameInstanceImpl();
    @Nullable
    private static MinecraftServer currentServer;

    private GameInstanceImpl() {
    }

    @Override
    @Nullable
    public MinecraftServer getCurrentServer() {
        if (currentServer == null && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            currentServer = (MinecraftServer)class_310.method_1551().method_1576();
        }
        return currentServer;
    }

    public final void onLoadServer(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        currentServer = server;
    }

    public final void onUnloadServer() {
        currentServer = null;
    }

    @Override
    @NotNull
    public class_1255<? super class_3738> getEventLoop(@NotNull Environment side) {
        class_1255 class_12552;
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        if (side == Environment.CLIENT) {
            class_310 class_3102 = class_310.method_1551();
            Intrinsics.checkNotNullExpressionValue((Object)class_3102, (String)"getInstance(...)");
            class_12552 = (class_1255)class_3102;
        } else {
            MinecraftServer minecraftServer = this.getCurrentServer();
            if (minecraftServer == null) {
                throw new IllegalStateException("Cannot get server executor before server is loaded".toString());
            }
            class_12552 = (class_1255)minecraftServer;
        }
        return class_12552;
    }

    @Override
    @NotNull
    public byte[] getClassBytes(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        byte[] byArray = FabricLauncherBase.getLauncher().getClassByteArray(className, false);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getClassByteArray(...)");
        return byArray;
    }

    @Override
    public void execute(@NotNull Environment side, @NotNull Runnable action) {
        GameInstance.super.execute(side, action);
    }
}

