/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.client.ScreenHelper;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.network.ConvertPacket;
import com.shiftthedev.pickablepets.network.ManagePetsPacket;
import com.shiftthedev.pickablepets.utils.PetInfo;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CachedPets {
    private static TreeMap<UUID, PetInfo> pets = new TreeMap();
    private static class_1937 overworldLevel;

    public static boolean isValidPet(String uuid) {
        return pets.containsKey(UUID.fromString(uuid));
    }

    public static class_1309 getPet(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getPetEntity();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1309 getRender(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getRender();
        }
        ManagePetsPacket.sendToServer(uuid);
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1309 getItemRender(class_1799 petStack) {
        class_2487 tag = petStack.method_7911("pet_info");
        if (!tag.method_10545("VERSION")) {
            ConvertPacket.sendToServer(petStack);
            tag.method_10569("VERSION", 2);
        }
        if (tag.method_10550("VERSION") != 2) {
            ConvertPacket.sendToServer(petStack);
            tag.method_10569("VERSION", 2);
        }
        if (tag.method_10545("UUID")) {
            return CachedPets.getRender(tag.method_25926("UUID"));
        }
        return null;
    }

    public static String getOwner(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getOwner();
        }
        return "";
    }

    public static class_2499 getPetAttributes(UUID petUUID) {
        if (pets.containsKey(petUUID)) {
            return pets.get(petUUID).getAttributes();
        }
        return new class_2499();
    }

    public static void addOldPet(@Nullable class_2487 oldTag) {
        if (overworldLevel == null) {
            return;
        }
        Optional entityType = class_1299.method_5898((String)oldTag.method_10558("pet_type"));
        if (entityType.isEmpty()) {
            return;
        }
        class_1309 entity = (class_1309)((class_1299)entityType.get()).method_5883(overworldLevel);
        if (entity == null) {
            return;
        }
        if (!(entity instanceof class_6025)) {
            return;
        }
        entity.method_5651(oldTag);
        if (pets.containsKey(entity.method_5667())) {
            if (oldTag.method_10550("VERSION") == 1) {
                pets.get(entity.method_5667()).updateAttributes(entity);
            }
            pets.get(entity.method_5667()).updateEntity(entity);
        } else {
            pets.put(entity.method_5667(), new PetInfo(entity, oldTag.method_10558("owner_name")));
        }
        oldTag.method_10569("VERSION", 2);
        pets.get(entity.method_5667()).setInItem(true);
        CachedPets.sendPetsToPlayers(overworldLevel, entity.method_5667());
    }

    public static void addPet(class_1309 entity) {
        if (pets.containsKey(entity.method_5667())) {
            pets.get(entity.method_5667()).updateEntity(entity);
        } else {
            pets.put(entity.method_5667(), new PetInfo(entity));
        }
    }

    public static void replaceWolf(class_3222 player, UUID oldID, class_1321 dog) {
        if (dog.method_5667().equals(oldID) && pets.containsKey(dog.method_5667())) {
            pets.get(dog.method_5667()).updateEntity((class_1309)dog);
            return;
        }
        pets.remove(oldID);
        class_1937 level = dog.method_37908();
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (dog.method_6139() == null) {
            return;
        }
        pets.put(dog.method_5667(), new PetInfo((class_1309)dog));
        PlayerPets.replacePetAsync((class_3218)level, dog.method_6139(), oldID, dog.method_5667());
        CachedPets.sendRemovePet(level, oldID);
        CachedPets.sendPetsToPlayer(player, dog.method_5667());
    }

    public static void removePet(UUID uuid, @Nullable class_1937 level) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        class_1309 pet = pets.get(uuid).getPetEntity();
        if (!level.field_9236) {
            UUID ownerID;
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(pet)) {
                PlayerPets.removePetAsync((class_3218)level, DawnEraHelper.getOwnerUUID(pet), uuid);
            } else if (PickablePets.FoundGoety && GoetyHelper.isFromMod(pet)) {
                PlayerPets.removePetAsync((class_3218)level, GoetyHelper.getOwnerUUID(pet), uuid);
            } else if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(pet)) {
                PlayerPets.removePetAsync((class_3218)level, DoggyHelper.getOwnerUUID(pet), uuid);
            } else if (pet instanceof class_6025 && (ownerID = ((class_6025)pet).method_6139()) != null) {
                PlayerPets.removePetAsync((class_3218)level, ownerID, uuid);
            }
        }
        pets.remove(uuid);
        CachedPets.sendRemovePet(level, uuid);
    }

    public static void setPetItem(UUID uuid, boolean flag) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).setInItem(flag);
    }

    public static boolean isInItem(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).isInItem();
    }

    public static void killPet(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).markDead();
    }

    public static void revivePet(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).revive();
    }

    public static boolean isPetAlive(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).isAlive();
    }

    public static class_2561 getPetName(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getName();
        }
        ManagePetsPacket.sendToServer(uuid);
        return class_2561.method_43473();
    }

    public static void setUpdated(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).setUpdated();
    }

    public static boolean isPetUpdated(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).isUpdated();
    }

    public static boolean wasPetRevived(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).wasRevived();
    }

    public static void save(Path path) {
        class_2499 listTag = new class_2499();
        TreeMap<UUID, PetInfo> tempMap = new TreeMap<UUID, PetInfo>();
        for (Map.Entry<UUID, PetInfo> petEntry : pets.entrySet()) {
            class_2487 entryTag = new class_2487();
            entryTag.method_25927("Key", petEntry.getKey());
            entryTag.method_10566("Value", (class_2520)petEntry.getValue().save(new class_2487()));
            listTag.add((Object)entryTag);
            tempMap.put(petEntry.getKey(), petEntry.getValue());
        }
        pets.clear();
        pets = new TreeMap();
        pets.putAll(tempMap);
        class_2487 tag = new class_2487();
        tag.method_10566("pets", (class_2520)listTag);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        File file = new File(path.toFile(), "pets.dat");
        try {
            class_2507.method_30614((class_2487)tag, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void load(Path path, MinecraftServer server) {
        class_2487 tag;
        overworldLevel = server.method_30002();
        pets = new TreeMap();
        File file = new File(path.toFile(), "pets.dat");
        if (!file.exists()) {
            return;
        }
        try {
            tag = class_2507.method_30613((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tag == null) {
            return;
        }
        if (!tag.method_10545("pets")) {
            return;
        }
        pets.clear();
        class_2499 listTag = tag.method_10554("pets", 10);
        for (class_2520 entry : listTag) {
            if (!(entry instanceof class_2487)) continue;
            class_2487 entryTag = (class_2487)entry;
            class_2487 value = entryTag.method_10562("Value");
            UUID petId = entryTag.method_25926("Key");
            PetInfo petEntry = new PetInfo();
            petEntry.load(petId, value, overworldLevel);
            pets.put(petId, petEntry);
        }
    }

    public static void clearData() {
        if (pets != null) {
            pets.clear();
        }
        pets = new TreeMap();
        overworldLevel = null;
    }

    public static void sendPetsToPlayers(class_1937 level, UUID petUUID) {
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.field_9236) {
            return;
        }
        level.method_18456().forEach(player -> CachedPets.sendPetsToPlayer((class_3222)player, petUUID));
    }

    public static void sendPetsToPlayer(class_3222 player, UUID requestedUUID) {
        if (!pets.containsKey(requestedUUID)) {
            return;
        }
        ManagePetsPacket.sendToPlayer(requestedUUID, pets.get(requestedUUID).save(new class_2487()), player);
    }

    public static void sendRemovePet(class_1937 level, UUID uuid) {
        if (level.field_9236) {
            return;
        }
        level.method_18456().forEach(player -> CachedPets.sendPetsToPlayer((class_3222)player, uuid));
    }

    @Environment(value=EnvType.CLIENT)
    public static void getPetFromServer(UUID petUUID, class_2487 petTag, class_1937 level) {
        PetInfo serverPet = new PetInfo();
        serverPet.load(petUUID, petTag, level);
        ScreenHelper.tryUpdateScreen(true);
        pets.remove(petUUID);
        pets.put(petUUID, serverPet);
    }
}

