/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.fabric.network;

import corgitaco.corgilib.CorgiLib;
import corgitaco.corgilib.network.Packet;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_638;

public class FabricNetworkHandler {
    private static final String PACKET_LOCATION = "corgilib";
    private static final Function<String, class_2960> PACKET_ID = id -> {
        class_2960 value = new class_2960(id);
        return value.method_12836().equals("minecraft") ? CorgiLib.createLocation(id) : value;
    };
    private static final Map<Class<? extends Packet>, BiConsumer<?, class_2540>> ENCODERS = new ConcurrentHashMap();
    private static final Map<Class<? extends Packet>, class_2960> PACKET_IDS = new ConcurrentHashMap<Class<? extends Packet>, class_2960>();

    public static void init() {
        Packet.PACKETS.forEach(FabricNetworkHandler::register);
    }

    private static <T extends Packet> void register(String path, Packet.Handler<T> handler) {
        FabricNetworkHandler.registerMessage(path, handler.clazz(), handler.direction(), handler.write(), handler.read(), handler.handle());
    }

    private static <T extends Packet> void registerMessage(String id, Class<T> clazz, Packet.PacketDirection direction, BiConsumer<T, class_2540> encode, Function<class_2540, T> decode, Packet.Handle<T> handler) {
        ENCODERS.put(clazz, encode);
        PACKET_IDS.put(clazz, PACKET_ID.apply(id));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && direction == Packet.PacketDirection.SERVER_TO_CLIENT) {
            ClientProxy.registerClientReceiver(id, decode, handler);
        }
        if (direction == Packet.PacketDirection.CLIENT_TO_SERVER) {
            ServerProxy.registerServerReceiver(id, decode, handler);
        }
    }

    public static <MSG extends Packet> void sendToPlayer(class_3222 player, MSG packet) {
        class_2960 packetId = PACKET_IDS.get(packet.getClass());
        BiConsumer<?, class_2540> encoder = ENCODERS.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf);
    }

    public static <MSG extends Packet> void sendToAllPlayers(List<class_3222> players, MSG packet) {
        players.forEach(player -> FabricNetworkHandler.sendToPlayer(player, packet));
    }

    public static <MSG extends Packet> void sendToServer(MSG packet) {
        class_2960 packetId = PACKET_IDS.get(packet.getClass());
        BiConsumer<?, class_2540> encoder = ENCODERS.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        ClientPlayNetworking.send((class_2960)packetId, (class_2540)buf);
    }

    public record ClientProxy() {
        public static <T extends Packet> void registerClientReceiver(String id, Function<class_2540, T> decode, Packet.Handle<T> handler) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)PACKET_ID.apply(id), (client, listener, buf, responseSender) -> {
                buf.retain();
                client.execute(() -> {
                    Packet packet = (Packet)decode.apply(buf);
                    class_638 level = client.field_1687;
                    if (level != null) {
                        try {
                            handler.handle(packet, (class_1937)level, (class_1657)class_310.method_1551().field_1724);
                        }
                        catch (Throwable throwable) {
                            CorgiLib.LOGGER.error("Packet failed: ", throwable);
                            throw throwable;
                        }
                    }
                    buf.release();
                });
            });
        }
    }

    public static class ServerProxy {
        private static <T extends Packet> void registerServerReceiver(String id, Function<class_2540, T> decode, Packet.Handle<T> handler) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)PACKET_ID.apply(id), (server, player, handler1, buf, responseSender) -> {
                buf.retain();
                server.execute(() -> {
                    Packet packet = (Packet)decode.apply(buf);
                    class_1937 level = player.method_37908();
                    try {
                        handler.handle(packet, level, (class_1657)player);
                    }
                    catch (Throwable throwable) {
                        CorgiLib.LOGGER.error("Packet failed: ", throwable);
                        throw throwable;
                    }
                    buf.release();
                });
            });
        }
    }
}

