/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.multipart_entities.util;

import com.cerbon.cerbons_api.api.multipart_entities.util.Matrix3d;
import com.cerbon.cerbons_api.api.multipart_entities.util.QuaternionD;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public final class OrientedBox {
    private final class_243 center;
    private final class_243 halfExtents;
    private final QuaternionD rotation;
    private class_238 extents;
    private Matrix3d matrix;
    private Matrix3d inverse;
    private class_243[] vertices;
    private class_243[] basis;

    public OrientedBox(class_238 box) {
        this.center = box.method_1005();
        this.halfExtents = new class_243(box.method_17939() / 2.0, box.method_17940() / 2.0, box.method_17941() / 2.0);
        this.rotation = QuaternionD.IDENTITY;
    }

    public OrientedBox(class_243 center, class_243 halfExtents, QuaternionD rotation) {
        this.center = center;
        this.halfExtents = halfExtents;
        this.rotation = rotation;
    }

    public OrientedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, QuaternionD rotation) {
        this.center = new class_243((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
        this.halfExtents = new class_243((maxX - minX) / 2.0, (maxY - minY) / 2.0, (maxZ - minZ) / 2.0);
        this.rotation = rotation;
    }

    private OrientedBox(class_243 center, class_243 halfExtents, QuaternionD rotation, Matrix3d matrix, Matrix3d inverse, class_243[] basis) {
        this.center = center;
        this.halfExtents = halfExtents;
        this.rotation = rotation;
        this.matrix = matrix;
        this.inverse = inverse;
        this.basis = basis;
    }

    public Matrix3d getMatrix() {
        if (this.matrix == null) {
            this.matrix = new Matrix3d(this.rotation);
        }
        return this.matrix;
    }

    public Matrix3d getInverse() {
        if (this.inverse == null) {
            this.inverse = this.getMatrix().invert();
        }
        return this.inverse;
    }

    public class_238 getExtents() {
        if (this.extents == null) {
            this.extents = new class_238(this.halfExtents.method_18805(-1.0, -1.0, -1.0), this.halfExtents);
        }
        return this.extents;
    }

    public class_243[] getBasis() {
        if (this.basis == null) {
            this.basis = this.matrix.getBasis();
        }
        return this.basis;
    }

    public OrientedBox rotate(QuaternionD quaternion) {
        if (QuaternionD.IDENTITY.equals(quaternion)) {
            return this;
        }
        return new OrientedBox(this.center, this.halfExtents, this.rotation.hamiltonProduct(quaternion));
    }

    public OrientedBox translate(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return this;
        }
        Matrix3d matrix = this.getMatrix();
        double transX = matrix.transformX(x, y, z);
        double transY = matrix.transformY(x, y, z);
        double transZ = matrix.transformZ(x, y, z);
        return new OrientedBox(this.center.method_1031(transX, transY, transZ), this.halfExtents, this.rotation, matrix, this.inverse, this.basis);
    }

    public OrientedBox transform(double x, double y, double z, double pivotX, double pivotY, double pivotZ, QuaternionD quaternion) {
        class_243 vec = this.getMatrix().transform(x - pivotX, y - pivotY, z - pivotZ);
        boolean bl = quaternion.equals(QuaternionD.IDENTITY);
        return new OrientedBox(this.center.method_1019(vec), this.halfExtents, this.rotation.hamiltonProduct(quaternion), bl ? this.matrix : null, bl ? this.inverse : null, bl ? this.basis : null).translate(pivotX, pivotY, pivotZ);
    }

    public QuaternionD getRotation() {
        return this.rotation;
    }

    public class_243 getCenter() {
        return this.center;
    }

    public class_243 getHalfExtents() {
        return this.halfExtents;
    }

    public OrientedBox offset(double x, double y, double z) {
        return new OrientedBox(this.center.method_1031(x, y, z), this.halfExtents, this.rotation, this.matrix, this.inverse, this.basis);
    }

    private void computeVertices() {
        class_238 box = this.getExtents();
        class_243[] vertices = OrientedBox.getVertices(box);
        this.vertices = new class_243[8];
        Matrix3d matrix = this.getMatrix();
        for (int i = 0; i < vertices.length; ++i) {
            this.vertices[i] = matrix.transform(vertices[i]).method_1019(this.center);
        }
    }

    public static class_243[] getVertices(class_238 box) {
        class_2350.class_2352[] axisDirections;
        class_243[] vertices = new class_243[8];
        int index = 0;
        for (class_2350.class_2352 x : axisDirections = class_2350.class_2352.values()) {
            for (class_2350.class_2352 y : axisDirections) {
                for (class_2350.class_2352 z : axisDirections) {
                    vertices[index++] = new class_243(OrientedBox.getPoint(box, x, class_2350.class_2351.field_11048), OrientedBox.getPoint(box, y, class_2350.class_2351.field_11052), OrientedBox.getPoint(box, z, class_2350.class_2351.field_11051));
                }
            }
        }
        return vertices;
    }

    private static double getPoint(class_238 box, class_2350.class_2352 direction, class_2350.class_2351 axis) {
        return direction == class_2350.class_2352.field_11060 ? box.method_1001(axis) : box.method_990(axis);
    }

    public boolean intersects(class_238 other) {
        return this.intersects(OrientedBox.getVertices(other));
    }

    public boolean intersects(class_243[] otherVertices) {
        class_243[] normals2;
        class_243[] normals1;
        if (this.vertices == null) {
            this.computeVertices();
        }
        class_243[] vertices1 = this.vertices;
        for (class_243 normal : normals1 = this.getBasis()) {
            if (OrientedBox.sat(normal, vertices1, otherVertices)) continue;
            return false;
        }
        for (class_243 normal : normals2 = Matrix3d.IDENTITY_BASIS) {
            if (OrientedBox.sat(normal, vertices1, otherVertices)) continue;
            return false;
        }
        for (int i = 0; i < normals1.length; ++i) {
            for (int j = i; j < normals2.length; ++j) {
                class_243 normal = OrientedBox.cross(normals1[i], normals2[j]);
                if (OrientedBox.sat(normal, vertices1, otherVertices)) continue;
                return false;
            }
        }
        return true;
    }

    private static class_243 cross(class_243 first, class_243 second) {
        return new class_243(first.field_1351 * second.field_1350 - first.field_1350 * second.field_1351, first.field_1350 * second.field_1352 - first.field_1352 * second.field_1350, first.field_1352 * second.field_1351 - first.field_1351 * second.field_1352);
    }

    private static boolean sat(class_243 normal, class_243[] vertices1, class_243[] vertices2) {
        double min1 = Double.MAX_VALUE;
        double max1 = -1.7976931348623157E308;
        for (class_243 d : vertices1) {
            double v = d.method_1026(normal);
            min1 = Math.min(min1, v);
            max1 = Math.max(max1, v);
        }
        double min2 = Double.MAX_VALUE;
        double max2 = -1.7976931348623157E308;
        for (class_243 vec3d : vertices2) {
            double v = vec3d.method_1026(normal);
            min2 = Math.min(min2, v);
            max2 = Math.max(max2, v);
        }
        return min1 <= min2 && min2 <= max1 || min2 <= min1 && min1 <= max2;
    }

    public double raycast(class_243 start, class_243 end) {
        Matrix3d inverse = this.getInverse();
        class_243 d = inverse.transform(start.field_1352 - this.center.field_1352, start.field_1351 - this.center.field_1351, start.field_1350 - this.center.field_1350);
        class_243 e = inverse.transform(end.field_1352 - this.center.field_1352, end.field_1351 - this.center.field_1351, end.field_1350 - this.center.field_1350);
        return this.raycast0(d, e);
    }

    private double raycast0(class_243 start, class_243 end) {
        double d = end.field_1352 - start.field_1352;
        double e = end.field_1351 - start.field_1351;
        double f = end.field_1350 - start.field_1350;
        double[] t = new double[]{1.0};
        class_2350 direction = OrientedBox.traceCollisionSide(this.getExtents(), start, t, d, e, f);
        if (direction != null) {
            return t[0];
        }
        return -1.0;
    }

    @Nullable
    private static class_2350 traceCollisionSide(class_238 box, class_243 intersectingVector, double[] traceDistanceResult, double xDelta, double yDelta, double zDelta) {
        class_2350 approachDirection = null;
        if (xDelta > 1.0E-7) {
            approachDirection = OrientedBox.traceCollisionSide(traceDistanceResult, approachDirection, xDelta, yDelta, zDelta, box.field_1323, box.field_1322, box.field_1325, box.field_1321, box.field_1324, class_2350.field_11039, intersectingVector.field_1352, intersectingVector.field_1351, intersectingVector.field_1350);
        } else if (xDelta < -1.0E-7) {
            approachDirection = OrientedBox.traceCollisionSide(traceDistanceResult, approachDirection, xDelta, yDelta, zDelta, box.field_1320, box.field_1322, box.field_1325, box.field_1321, box.field_1324, class_2350.field_11034, intersectingVector.field_1352, intersectingVector.field_1351, intersectingVector.field_1350);
        }
        if (yDelta > 1.0E-7) {
            approachDirection = OrientedBox.traceCollisionSide(traceDistanceResult, approachDirection, yDelta, zDelta, xDelta, box.field_1322, box.field_1321, box.field_1324, box.field_1323, box.field_1320, class_2350.field_11033, intersectingVector.field_1351, intersectingVector.field_1350, intersectingVector.field_1352);
        } else if (yDelta < -1.0E-7) {
            approachDirection = OrientedBox.traceCollisionSide(traceDistanceResult, approachDirection, yDelta, zDelta, xDelta, box.field_1325, box.field_1321, box.field_1324, box.field_1323, box.field_1320, class_2350.field_11036, intersectingVector.field_1351, intersectingVector.field_1350, intersectingVector.field_1352);
        }
        if (zDelta > 1.0E-7) {
            approachDirection = OrientedBox.traceCollisionSide(traceDistanceResult, approachDirection, zDelta, xDelta, yDelta, box.field_1321, box.field_1323, box.field_1320, box.field_1322, box.field_1325, class_2350.field_11043, intersectingVector.field_1350, intersectingVector.field_1352, intersectingVector.field_1351);
        } else if (zDelta < -1.0E-7) {
            approachDirection = OrientedBox.traceCollisionSide(traceDistanceResult, approachDirection, zDelta, xDelta, yDelta, box.field_1324, box.field_1323, box.field_1320, box.field_1322, box.field_1325, class_2350.field_11035, intersectingVector.field_1350, intersectingVector.field_1352, intersectingVector.field_1351);
        }
        return approachDirection;
    }

    @Nullable
    private static class_2350 traceCollisionSide(double[] traceDistanceResult, class_2350 approachDirection, double xDelta, double yDelta, double zDelta, double begin, double minX, double maxX, double minZ, double maxZ, class_2350 resultDirection, double startX, double startY, double startZ) {
        double d = (begin - startX) / xDelta;
        double e = startY + d * yDelta;
        double f = startZ + d * zDelta;
        if (0.0 < d && d < traceDistanceResult[0] && minX - 1.0E-7 < e && e < maxX + 1.0E-7 && minZ - 1.0E-7 < f && f < maxZ + 1.0E-7) {
            traceDistanceResult[0] = d;
            return resultDirection;
        }
        return approachDirection;
    }

    public boolean contains(double x, double y, double z) {
        double transX = this.getMatrix().transformX(x -= this.center.field_1352, y -= this.center.field_1351, z -= this.center.field_1350);
        double transY = this.getMatrix().transformY(x, y, z);
        double transZ = this.getMatrix().transformZ(x, y, z);
        return this.getExtents().method_1008(transX, transY, transZ);
    }

    public double getMax(class_2350.class_2351 axis) {
        Matrix3d matrix = this.getMatrix();
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> Math.max(matrix.m00, Math.max(matrix.m01, matrix.m02)) * this.halfExtents.field_1352 + this.center.field_1352;
            case class_2350.class_2351.field_11052 -> Math.max(matrix.m10, Math.max(matrix.m11, matrix.m12)) * this.halfExtents.field_1351 + this.center.field_1351;
            case class_2350.class_2351.field_11051 -> Math.max(matrix.m20, Math.max(matrix.m21, matrix.m22)) * this.halfExtents.field_1350 + this.center.field_1350;
        };
    }

    public double getMin(class_2350.class_2351 axis) {
        Matrix3d matrix = this.getMatrix();
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> Math.min(matrix.m00, Math.min(matrix.m01, matrix.m02)) * this.halfExtents.field_1352 + this.center.field_1352;
            case class_2350.class_2351.field_11052 -> Math.min(matrix.m10, Math.min(matrix.m11, matrix.m12)) * this.halfExtents.field_1351 + this.center.field_1351;
            case class_2350.class_2351.field_11051 -> Math.min(matrix.m20, Math.min(matrix.m21, matrix.m22)) * this.halfExtents.field_1350 + this.center.field_1350;
        };
    }

    public OrientedBox expand(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return this;
        }
        return new OrientedBox(this.center, this.halfExtents.method_1031(x / 2.0, y / 2.0, z / 2.0), this.rotation, this.matrix, this.inverse, this.basis);
    }
}

