/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.general.particle;

import com.cerbon.cerbons_api.api.general.particle.IParticleGeometry;
import com.cerbon.cerbons_api.api.general.particle.ParticleContext;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.function.Function;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SimpleParticle
extends class_4003 {
    private final ParticleContext particleContext;
    private final IParticleGeometry particleGeometry;
    private final boolean cycleSprites;
    private Function<SimpleParticle, Float> rotationOverride;
    private Function<SimpleParticle, class_243> velocityOverride;
    private Function<SimpleParticle, class_243> positionOverride;
    private Function<Float, Float> scaleOverride;
    private Function<Float, class_243> colorOverride;
    private Function<Float, Integer> brightnessOverride;
    private class_243 colorVariation = class_243.field_1353;
    private float prevRotation = 0.0f;
    private float rotation = 0.0f;
    public float ageRatio = 1.0f;

    public SimpleParticle(ParticleContext particleContext, int particleAge, IParticleGeometry particleGeometry, boolean cycleSprites, boolean doCollision) {
        super(particleContext.level(), particleContext.pos().method_10216(), particleContext.pos().method_10214(), particleContext.pos().method_10215());
        this.particleContext = particleContext;
        this.field_3847 = particleAge;
        this.particleGeometry = particleGeometry;
        this.cycleSprites = cycleSprites;
        this.field_3862 = doCollision;
        this.field_3852 = particleContext.vel().method_10216();
        this.field_3869 = particleContext.vel().method_10214();
        this.field_3850 = particleContext.vel().method_10215();
        if (cycleSprites) {
            this.method_18142(particleContext.spriteSet());
        } else {
            this.method_18141(particleContext.spriteSet().method_18139(this.field_3840));
        }
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17828;
    }

    @NotNull
    public class_243 getPos() {
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    public int getAge() {
        return this.field_3866;
    }

    public void method_3070() {
        super.method_3070();
        if (!this.method_3086()) {
            return;
        }
        if (this.cycleSprites) {
            this.method_18142(this.particleContext.spriteSet());
        }
        this.ageRatio = (float)this.field_3866 / (float)this.field_3847;
        this.setColorFromOverride(this.colorOverride, this.ageRatio);
        this.setScaleFromOverride(this.scaleOverride, this.ageRatio);
        this.setVelocityFromOverride(this.velocityOverride);
        this.setPositionFromOverride(this.positionOverride);
        this.setRotationFromOverride(this.rotationOverride);
    }

    private void setRotationFromOverride(Function<SimpleParticle, Float> rotationOverride) {
        if (rotationOverride == null) {
            return;
        }
        float rot = rotationOverride.apply(this).floatValue();
        this.prevRotation = this.rotation;
        this.rotation = rot;
    }

    private void setVelocityFromOverride(Function<SimpleParticle, class_243> velocityOverride) {
        if (velocityOverride == null) {
            return;
        }
        class_243 velocity = velocityOverride.apply(this);
        this.field_3852 = velocity.method_10216();
        this.field_3869 = velocity.method_10214();
        this.field_3850 = velocity.method_10215();
    }

    private void setPositionFromOverride(Function<SimpleParticle, class_243> positionOverride) {
        if (positionOverride == null) {
            return;
        }
        class_243 pos = positionOverride.apply(this);
        this.method_3063(pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    private void setScaleFromOverride(Function<Float, Float> scaleOverride, float ageRatio) {
        if (scaleOverride == null) {
            return;
        }
        this.field_17867 = scaleOverride.apply(Float.valueOf(ageRatio)).floatValue();
        this.method_3080(0.2f * this.field_17867, 0.2f * this.field_17867);
    }

    private void setColorFromOverride(Function<Float, class_243> colorOverride, float ageRatio) {
        if (colorOverride == null) {
            return;
        }
        class_243 color = colorOverride.apply(Float.valueOf(ageRatio));
        class_243 variedColor = VecUtils.coerceAtMost(VecUtils.coerceAtLeast(color.method_1019(this.colorVariation), class_243.field_1353), VecUtils.unit);
        this.method_3084((float)variedColor.method_10216(), (float)variedColor.method_10214(), (float)variedColor.method_10215());
    }

    public void setBrightnessOverride(Function<Float, Integer> override) {
        this.brightnessOverride = override;
    }

    public void setColorOverride(Function<Float, class_243> override) {
        this.colorOverride = override;
        this.setColorFromOverride(override, 0.0f);
    }

    public void setScaleOverride(Function<Float, Float> override) {
        this.scaleOverride = override;
        this.setScaleFromOverride(override, 0.0f);
    }

    public void setColorVariation(double variation) {
        this.colorVariation = RandomUtils.randVec().method_1021(variation);
        this.setColorFromOverride(this.colorOverride, 0.0f);
    }

    public void setVelocityOverride(Function<SimpleParticle, class_243> override) {
        this.velocityOverride = override;
    }

    public void setPositionOverride(Function<SimpleParticle, class_243> override) {
        this.positionOverride = override;
    }

    public void setRotationOverride(Function<SimpleParticle, Float> override) {
        this.rotationOverride = override;
        if (this.rotationOverride != null) {
            this.rotation = this.rotationOverride.apply(this).floatValue();
            this.prevRotation = this.rotationOverride.apply(this).floatValue();
        }
    }

    protected int method_3068(float partialTick) {
        return this.brightnessOverride != null ? this.brightnessOverride.apply(Float.valueOf(this.ageRatio)).intValue() : super.method_3068(partialTick);
    }

    public void method_3074(class_4588 vertexConsumer, @NotNull class_4184 camera, float partialTicks) {
        Vector3f[] vector3fs = this.particleGeometry.getGeometry(camera, partialTicks, this.field_3858, this.field_3838, this.field_3856, this.field_3874, this.field_3854, this.field_3871, this.method_18132(partialTicks), class_3532.method_16439((float)partialTicks, (float)this.prevRotation, (float)this.rotation));
        float l = this.method_18133();
        float m = this.method_18134();
        float n = this.method_18135();
        float o = this.method_18136();
        float p = this.method_3068(partialTicks);
        vertexConsumer.method_22912((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).method_22913(m, o).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916((int)p).method_1344();
        vertexConsumer.method_22912((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).method_22913(m, n).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916((int)p).method_1344();
        vertexConsumer.method_22912((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).method_22913(l, n).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916((int)p).method_1344();
        vertexConsumer.method_22912((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).method_22913(l, o).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22916((int)p).method_1344();
    }
}

