/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry.helper.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.valhelsia.valhelsia_core.api.client.ValhelsiaRenderType;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.ToolTier;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.ToolType;
import org.jetbrains.annotations.Nullable;

public class BlockRegistryEntry<T extends class_2248>
extends RegistryEntry<T> {
    private static final ItemFunction DEFAULT_ITEM_FUNCTION = registryObject -> new class_1747((class_2248)registryObject.get(), new class_1792.class_1793());
    private final String name;
    @Nullable
    private ToolType toolType = null;
    @Nullable
    private ToolTier toolTier = null;
    @Nullable
    private ItemFunction itemFunction;
    private ValhelsiaRenderType renderType = ValhelsiaRenderType.SOLID;

    public BlockRegistryEntry(String name, Supplier<T> entry) {
        super(entry);
        this.name = name;
    }

    public <O extends T> BlockRegistryEntry<O> withItem() {
        return this.withItem(DEFAULT_ITEM_FUNCTION);
    }

    public <O extends T> BlockRegistryEntry<O> withItem(ItemFunction function) {
        this.itemFunction = function;
        return this;
    }

    public final <O extends T> BlockRegistryEntry<O> toolType(ToolType toolType) {
        this.toolType = toolType;
        return this;
    }

    public final <O extends T> BlockRegistryEntry<O> toolTier(ToolTier toolTier) {
        this.toolTier = toolTier;
        return this;
    }

    public final <O extends T> BlockRegistryEntry<O> renderType(ValhelsiaRenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public ItemFunction getItemFunction() {
        return this.itemFunction;
    }

    public Optional<ToolType> getToolType() {
        return Optional.ofNullable(this.toolType);
    }

    public Optional<ToolTier> getToolTier() {
        return Optional.ofNullable(this.toolTier);
    }

    public ValhelsiaRenderType getRenderType() {
        return this.renderType;
    }

    @FunctionalInterface
    public static interface ItemFunction {
        public class_1747 apply(BlockRegistryEntry<? extends class_2248> var1);
    }
}

