/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.datagen.models;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockEntrySet;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_furniture.common.block.AbstractCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskDrawerBlock;
import net.valhelsia.valhelsia_furniture.common.block.FabricDeskLampBlock;
import net.valhelsia.valhelsia_furniture.common.block.FurnitureBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.common.block.UpholsteredChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;
import net.valhelsia.valhelsia_furniture.datagen.models.ModModelTemplates;
import net.valhelsia.valhelsia_furniture.datagen.models.ModTextureMapping;
import net.valhelsia.valhelsia_furniture.datagen.models.ModTextureSlots;

public class ModBlockModels {
    private final class_4910 generators;
    private final Consumer<class_4917> blockStateOutput;
    private final BiConsumer<class_2960, Supplier<JsonElement>> modelOutput;
    private final Consumer<class_1792> skippedAutoItemModels;

    private ModBlockModels(class_4910 generators, Consumer<class_1792> skippedAutoItemModels) {
        this.generators = generators;
        this.blockStateOutput = generators.field_22830;
        this.modelOutput = generators.field_22831;
        this.skippedAutoItemModels = skippedAutoItemModels;
    }

    public static void create(class_4910 generators, Consumer<class_1792> skippedAutoItemModels) {
        new ModBlockModels(generators, skippedAutoItemModels).createModels();
    }

    private void skipAutoItemBlock(class_2248 block) {
        this.skippedAutoItemModels.accept(block.method_8389());
    }

    public void createModels() {
        this.createTable((class_2248)ModBlocks.OAK_TABLE.get());
        this.createTable((class_2248)ModBlocks.SPRUCE_TABLE.get());
        this.createTable((class_2248)ModBlocks.BIRCH_TABLE.get());
        this.createTable((class_2248)ModBlocks.JUNGLE_TABLE.get());
        this.createTable((class_2248)ModBlocks.ACACIA_TABLE.get());
        this.createTable((class_2248)ModBlocks.CHERRY_TABLE.get());
        this.createTable((class_2248)ModBlocks.DARK_OAK_TABLE.get());
        this.createTable((class_2248)ModBlocks.MANGROVE_TABLE.get());
        this.createTable((class_2248)ModBlocks.CRIMSON_TABLE.get());
        this.createTable((class_2248)ModBlocks.WARPED_TABLE.get());
        this.apply(ModBlocks.COLORED_OAK_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_SPRUCE_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_BIRCH_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_JUNGLE_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_ACACIA_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_CHERRY_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_DARK_OAK_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_MANGROVE_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_CRIMSON_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_WARPED_TABLES, this::createTable);
        this.createChair((class_2248)ModBlocks.OAK_CHAIR.get());
        this.createChair((class_2248)ModBlocks.SPRUCE_CHAIR.get());
        this.createChair((class_2248)ModBlocks.BIRCH_CHAIR.get());
        this.createChair((class_2248)ModBlocks.JUNGLE_CHAIR.get());
        this.createChair((class_2248)ModBlocks.ACACIA_CHAIR.get());
        this.createChair((class_2248)ModBlocks.CHERRY_CHAIR.get());
        this.createChair((class_2248)ModBlocks.DARK_OAK_CHAIR.get());
        this.createChair((class_2248)ModBlocks.MANGROVE_CHAIR.get());
        this.createChair((class_2248)ModBlocks.CRIMSON_CHAIR.get());
        this.createChair((class_2248)ModBlocks.WARPED_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_OAK_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_SPRUCE_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_BIRCH_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_JUNGLE_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_ACACIA_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_CHERRY_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_DARK_OAK_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_MANGROVE_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_CRIMSON_CHAIR.get());
        this.createChair((class_2248)ModBlocks.HAY_WARPED_CHAIR.get());
        this.apply(ModBlocks.WOOL_OAK_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_SPRUCE_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_BIRCH_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_JUNGLE_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_ACACIA_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_CHERRY_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_DARK_OAK_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_MANGROVE_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_CRIMSON_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_WARPED_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_OAK_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_SPRUCE_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_BIRCH_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_JUNGLE_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_ACACIA_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CHERRY_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_MANGROVE_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CRIMSON_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_WARPED_CHAIRS, this::createUpholsteredChair);
        this.createStool((class_2248)ModBlocks.OAK_STOOL.get());
        this.createStool((class_2248)ModBlocks.SPRUCE_STOOL.get());
        this.createStool((class_2248)ModBlocks.BIRCH_STOOL.get());
        this.createStool((class_2248)ModBlocks.JUNGLE_STOOL.get());
        this.createStool((class_2248)ModBlocks.ACACIA_STOOL.get());
        this.createStool((class_2248)ModBlocks.CHERRY_STOOL.get());
        this.createStool((class_2248)ModBlocks.DARK_OAK_STOOL.get());
        this.createStool((class_2248)ModBlocks.MANGROVE_STOOL.get());
        this.createStool((class_2248)ModBlocks.CRIMSON_STOOL.get());
        this.createStool((class_2248)ModBlocks.WARPED_STOOL.get());
        this.apply(ModBlocks.WOOL_UPHOLSTERED_OAK_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_SPRUCE_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_BIRCH_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_JUNGLE_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_ACACIA_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CHERRY_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_MANGROVE_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CRIMSON_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_WARPED_STOOLS, this::createUpholsteredStool);
        this.createDesk((class_2248)ModBlocks.OAK_DESK.get());
        this.createDesk((class_2248)ModBlocks.SPRUCE_DESK.get());
        this.createDesk((class_2248)ModBlocks.BIRCH_DESK.get());
        this.createDesk((class_2248)ModBlocks.JUNGLE_DESK.get());
        this.createDesk((class_2248)ModBlocks.ACACIA_DESK.get());
        this.createDesk((class_2248)ModBlocks.CHERRY_DESK.get());
        this.createDesk((class_2248)ModBlocks.DARK_OAK_DESK.get());
        this.createDesk((class_2248)ModBlocks.MANGROVE_DESK.get());
        this.createDesk((class_2248)ModBlocks.CRIMSON_DESK.get());
        this.createDesk((class_2248)ModBlocks.WARPED_DESK.get());
        this.createDesk((class_2248)ModBlocks.OAK_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.SPRUCE_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.BIRCH_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.JUNGLE_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.ACACIA_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.CHERRY_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.DARK_OAK_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.MANGROVE_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.CRIMSON_DESK_DRAWER.get());
        this.createDesk((class_2248)ModBlocks.WARPED_DESK_DRAWER.get());
        this.apply(ModBlocks.FABRIC_DESK_LAMPS, this::createDeskLamp);
        this.apply(ModBlocks.CLOSED_CURTAINS, (T block) -> this.createCurtain((AbstractCurtainBlock<?>)((Object)block), (class_2754<? extends CurtainPart>)ModBlockStateProperties.CLOSED_CURTAIN_PART));
        this.apply(ModBlocks.OPEN_CURTAINS, (T block) -> this.createCurtain((AbstractCurtainBlock<?>)((Object)block), (class_2754<? extends CurtainPart>)ModBlockStateProperties.OPEN_CURTAIN_PART));
    }

    private <T extends class_2248> void apply(BlockEntrySet<T, ?> set, Consumer<T> consumer) {
        for (BlockRegistryEntry entry : set.values()) {
            consumer.accept((class_2248)entry.get());
        }
    }

    private <T extends class_2248, K extends Enum<K>> void apply(BlockEntrySet<T, K> set, BiConsumer<T, K> consumer) {
        for (Map.Entry entry : set.entrySet()) {
            consumer.accept((class_2248)((BlockRegistryEntry)entry.getValue()).get(), (Enum)entry.getKey());
        }
    }

    private void createTable(class_2248 block) {
        if (!(block instanceof TableBlock)) {
            return;
        }
        TableBlock tableBlock = (TableBlock)block;
        String folder = FurnitureBlock.Type.TABLE.method_15434() + "/" + tableBlock.getWoodType().comp_1299();
        class_4944 textureMapping = new class_4944().method_25868(ModTextureSlots.TABLE, ModTextureMapping.getBlockTexture(block, folder)).method_25868(ModTextureSlots.CONNECTED_TABLE, ModTextureMapping.getBlockTexture(block, folder, "_connected"));
        this.createTableModels(block, textureMapping);
        class_4926 dispatch = class_4926.method_25787((class_2769)class_2741.field_12489, (class_2769)class_2741.field_12487, (class_2769)class_2741.field_12540, (class_2769)class_2741.field_12527, (class_2769)ModBlockStateProperties.ROTATED).method_35897((north, east, south, west, rotated) -> {
            String suffix;
            boolean connected = north != false || east != false || south != false || west != false;
            boolean allConnected = north != false && east != false && south != false && west != false;
            String string = suffix = connected ? "_" : "";
            if (north.booleanValue()) {
                String string2 = suffix = rotated != false && !allConnected ? suffix.concat("e") : suffix.concat("n");
            }
            if (east.booleanValue()) {
                String string3 = suffix = rotated != false && !allConnected ? suffix.concat("s") : suffix.concat("e");
            }
            if (south.booleanValue()) {
                String string4 = suffix = rotated != false && !allConnected ? suffix.concat("w") : suffix.concat("s");
            }
            if (west.booleanValue()) {
                suffix = rotated != false && !allConnected ? suffix.concat("n") : suffix.concat("w");
            }
            suffix = switch (suffix) {
                case "_esn" -> "_nes";
                case "_swn" -> "_nsw";
                case "_ewn" -> "_new";
                case "_sn" -> "_ns";
                case "_en" -> "_ne";
                case "_wn" -> "_nw";
                default -> suffix;
            };
            class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)block, (String)suffix));
            if (rotated.booleanValue()) {
                variant.method_25828(class_4936.field_22886, (Object)(!connected ? class_4936.class_4937.field_22891 : class_4936.class_4937.field_22893));
            }
            return variant;
        });
        this.blockStateOutput.accept((class_4917)class_4925.method_25769((class_2248)block).method_25775(dispatch));
    }

    private void createTableModels(class_2248 block, class_4944 mapping) {
        ModModelTemplates.TABLE.method_25846(block, mapping, this.modelOutput);
        ModModelTemplates.TABLE_N.method_25847(block, "_n", mapping, this.modelOutput);
        ModModelTemplates.TABLE_E.method_25847(block, "_e", mapping, this.modelOutput);
        ModModelTemplates.TABLE_S.method_25847(block, "_s", mapping, this.modelOutput);
        ModModelTemplates.TABLE_W.method_25847(block, "_w", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NE.method_25847(block, "_ne", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NES.method_25847(block, "_nes", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NESW.method_25847(block, "_nesw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NEW.method_25847(block, "_new", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NS.method_25847(block, "_ns", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NSW.method_25847(block, "_nsw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NW.method_25847(block, "_nw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_SW.method_25847(block, "_sw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_ES.method_25847(block, "_es", mapping, this.modelOutput);
        ModModelTemplates.TABLE_ESW.method_25847(block, "_esw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_EW.method_25847(block, "_ew", mapping, this.modelOutput);
    }

    private void createChair(class_2248 block) {
        if (!(block instanceof ChairBlock)) {
            return;
        }
        ChairBlock chairBlock = (ChairBlock)block;
        class_4944 textureMapping = new class_4944().method_25868(ModTextureSlots.CHAIR, ModTextureMapping.getBlockTexture(block, "chair/" + chairBlock.getWoodType().comp_1299()));
        class_2960 model = ModModelTemplates.CHAIR.method_25846(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((class_4917)ModBlockModels.createSimpleBlock(block, model).method_25775(class_4910.method_25599()));
    }

    private void createUpholsteredChair(UpholsteredChairBlock block) {
        class_4944 textureMapping = new class_4944().method_25868(ModTextureSlots.WOOL, new class_2960("valhelsia_furniture", "block/upholstered_chair/colors/" + block.getColor())).method_25868(ModTextureSlots.WOOD, new class_2960("valhelsia_furniture", "block/upholstered_chair/base/" + block.getWoodType().comp_1299()));
        class_2960 model = ModModelTemplates.UPHOLSTERED_CHAIR.method_25846((class_2248)block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((class_4917)ModBlockModels.createSimpleBlock(block, model).method_25775(class_4910.method_25599()));
    }

    private void createStool(class_2248 block) {
        class_4944 textureMapping = new class_4944().method_25868(ModTextureSlots.STOOL, ModTextureMapping.getBlockTexture(block, "stool"));
        class_2960 model = ModModelTemplates.STOOL.method_25846(block, textureMapping, this.modelOutput);
        class_2960 rotatedModel = ModModelTemplates.STOOL_ROTATED.method_25847(block, "_rotated", textureMapping, this.modelOutput);
        this.blockStateOutput.accept((class_4917)ModBlockModels.createSimpleBlock(block, model).method_25775(ModBlockModels.createRotatedDispatch(rotatedModel)));
    }

    private void createUpholsteredStool(StoolBlock block) {
        class_4944 textureMapping = new class_4944().method_25868(ModTextureSlots.WOOD, new class_2960("valhelsia_furniture", "block/upholstered_stool/base/" + block.getWoodType().comp_1299())).method_25868(ModTextureSlots.WOOL, new class_2960("valhelsia_furniture", "block/upholstered_stool/colors/" + block.getColor()));
        class_2960 model = ModModelTemplates.UPHOLSTERED_STOOL.method_25846((class_2248)block, textureMapping, this.modelOutput);
        class_2960 rotatedModel = ModModelTemplates.UPHOLSTERED_STOOL_ROTATED.method_25847((class_2248)block, "_rotated", textureMapping, this.modelOutput);
        this.blockStateOutput.accept((class_4917)ModBlockModels.createSimpleBlock(block, model).method_25775(ModBlockModels.createRotatedDispatch(rotatedModel)));
    }

    private void createDesk(class_2248 block) {
        if (!(block instanceof DeskBlock)) {
            return;
        }
        DeskBlock deskBlock = (DeskBlock)block;
        class_4926 dispatch = class_4926.method_25784((class_2769)ModBlockStateProperties.LEFT, (class_2769)ModBlockStateProperties.RIGHT).method_25800((left, right) -> {
            String variant = "";
            if (left.booleanValue() && right.booleanValue()) {
                variant = "_center";
            } else if (left.booleanValue()) {
                variant = "_right";
            } else if (right.booleanValue()) {
                variant = "_left";
            }
            List<class_4945> textureSlots = variant.equals("_left") || variant.equals("_right") ? DeskBlock.VARIANT_TEXTURES.get("left_or_right") : (variant.equals("_center") ? DeskBlock.VARIANT_TEXTURES.get("center") : DeskBlock.VARIANT_TEXTURES.get("single"));
            class_4944 textureMapping = new class_4944();
            for (class_4945 slot : textureSlots) {
                textureMapping.method_25868(slot, new class_2960("valhelsia_furniture", "block/desk/" + deskBlock.getWoodType().comp_1299() + "/" + slot.method_25912()));
            }
            class_2960 model = this.getDeskModel((boolean)left, (boolean)right, block instanceof DeskDrawerBlock).method_25847(block, variant, textureMapping, this.modelOutput);
            return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model);
        });
        this.blockStateOutput.accept((class_4917)class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25599()).method_25775(dispatch));
    }

    private class_4942 getDeskModel(boolean left, boolean right, boolean drawer) {
        if (left && right) {
            return drawer ? ModModelTemplates.DESK_DRAWER_CENTER : ModModelTemplates.DESK_CENTER;
        }
        if (left) {
            return drawer ? ModModelTemplates.DESK_DRAWER_RIGHT : ModModelTemplates.DESK_RIGHT;
        }
        if (right) {
            return drawer ? ModModelTemplates.DESK_DRAWER_LEFT : ModModelTemplates.DESK_LEFT;
        }
        return drawer ? ModModelTemplates.DESK_DRAWER : ModModelTemplates.DESK;
    }

    private void createDeskLamp(FabricDeskLampBlock block, class_1767 color) {
        class_4944 textureMapping = new class_4944().method_25868(ModTextureSlots.COLOR, new class_2960("valhelsia_furniture", "block/fabric_desk_lamp/colors/" + color.method_7792()));
        class_2960 model = ModModelTemplates.FABRIC_DESK_LAMP.method_25846((class_2248)block, textureMapping, this.modelOutput);
        class_2960 modelOn = ModModelTemplates.FABRIC_DESK_LAMP_ON.method_25847((class_2248)block, "_rotated", textureMapping, this.modelOutput);
        this.createSimpleFlatItemModel(block.method_8389());
        this.blockStateOutput.accept((class_4917)class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)ModBlockStateProperties.SWITCHED_ON, (class_2960)modelOn, (class_2960)model)));
    }

    private void createCurtain(AbstractCurtainBlock<?> block, class_2754<? extends CurtainPart> property) {
        for (CurtainPart part2 : property.method_11898()) {
            if (part2.getModelTemplate() == null) continue;
            String folder = "curtain/" + block.getColor().method_7792();
            class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, ModTextureMapping.getBlockTexture(folder, part2.getTopTexture())).method_25868(class_4945.field_23024, ModTextureMapping.getBlockTexture(folder, part2.getBottomTexture()));
            part2.getModelTemplate().method_25847(block, part2.getModelName(), textureMapping, this.modelOutput);
        }
        class_4926 dispatch = class_4926.method_25783(property).method_25795(part -> {
            class_2960 model = class_7923.field_41175.method_10221((Object)block).method_45134(s -> "block/" + s + ((CurtainPart)((Object)part)).getModelName());
            if (((CurtainPart)((Object)part)).getModelTemplate() == null) {
                model = new class_2960("valhelsia_furniture", "block/curtain/curtain_bracket");
            }
            return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model);
        });
        if (block instanceof ClosedCurtainBlock) {
            this.delegateItemModel(block, class_4941.method_25843(block, (String)"_single"));
        }
        this.blockStateOutput.accept((class_4917)class_4925.method_25769(block).method_25775(class_4910.method_25599()).method_25775(dispatch));
    }

    private static class_4925 createSimpleBlock(class_2248 block, class_2960 resourceLocation) {
        return class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation));
    }

    private static class_4926 createRotatedDispatch(class_2960 model) {
        return class_4926.method_25783((class_2769)ModBlockStateProperties.ROTATED).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824()).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model));
    }

    void createSimpleFlatItemModel(class_1792 item) {
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), this.modelOutput);
    }

    void delegateItemModel(class_2248 block, class_2960 resourceLocation) {
        this.modelOutput.accept(class_4941.method_25840((class_1792)block.method_8389()), (Supplier<JsonElement>)new class_4940(resourceLocation));
    }
}

