/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.io.File;
import java.net.URI;
import org.watermedia.WaterMedia;
import org.watermedia.api.network.patchs.AbstractPatch;

public class DiskPatch
extends AbstractPatch {
    @Override
    public String platform() {
        return "Local";
    }

    @Override
    public boolean isValid(URI uri) {
        String scheme = uri.getScheme();
        return scheme != null && scheme.equals("water");
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality prefQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, prefQuality);
        try {
            if (uri.getScheme().equals("water")) {
                switch (uri.getHost()) {
                    case "local": {
                        return new AbstractPatch.Result(new File("").toPath().resolve(uri.getPath().substring(1)).toUri(), false, false);
                    }
                    case "temp": {
                        return new AbstractPatch.Result(WaterMedia.getLoader().tempDir().resolve(uri.getPath().substring(1)).toUri(), false, false);
                    }
                }
            }
            throw new IllegalArgumentException("invalid water protocol");
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }
}

