/*
 * Decompiled with CFR 0.152.
 */
package ru.hollowhorizon.additions.questing.mixins;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.main.Main;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Main.class})
public class DebugMainMixin {
    @Inject(method={"main([Ljava/lang/String;)V"}, at={@At(value="HEAD")}, remap=false)
    private static void preMain(CallbackInfo ci) {
        String path = System.getProperty("java.library.path");
        String name = System.mapLibraryName("renderdoc");
        boolean detected = false;
        for (String folder : path.split(";")) {
            if (!Files.exists(Path.of(folder + "/" + name, new String[0]), new LinkOption[0])) continue;
            detected = true;
            break;
        }
        if (!detected) {
            Path renderDoc = Path.of("C:/Program Files/RenderDoc/renderdoc.dll", new String[0]);
            if (Files.exists(renderDoc, new LinkOption[0])) {
                try {
                    System.load("C:/Program Files/RenderDoc/renderdoc.dll");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            System.loadLibrary("renderdoc");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

