/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures.processors;

import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class WoolReplacingProcessor
extends class_3491 {
    private static final List<String> ALL_COLORS = Arrays.stream(class_1767.values()).map(class_1767::method_7792).toList();
    private static final Pattern PATTERN = Pattern.compile("minecraft:[a-z_]+_wool", 2);
    public static final Codec<WoolReplacingProcessor> CODEC = Codec.unit(WoolReplacingProcessor::new);
    private String color = null;

    public class_3499.class_3501 method_15110(class_4538 level, class_2338 var2, class_2338 var3, class_3499.class_3501 var4, class_3499.class_3501 var5, class_3492 settings) {
        class_5819 random = settings.method_15115(var5.comp_1341());
        this.ensureColor(random);
        if (!this.isWoolBlock(var5.comp_1342())) {
            return var5;
        }
        class_2680 replacement = this.getNewWool(this.color);
        if (replacement == null) {
            return var5;
        }
        return new class_3499.class_3501(var5.comp_1341(), replacement, var5.comp_1343());
    }

    private class_2680 getNewWool(String color) {
        class_2960 location = new class_2960(color + "_wool");
        if (class_7923.field_41175.method_10250(location)) {
            return ((class_2248)class_7923.field_41175.method_10223(location)).method_9564();
        }
        return null;
    }

    private void ensureColor(class_5819 random) {
        if (this.color == null) {
            this.color = ALL_COLORS.get(random.method_43048(ALL_COLORS.size()));
        }
    }

    private boolean isWoolBlock(class_2680 state) {
        String block_id = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        return PATTERN.matcher(block_id).find();
    }

    protected class_3828<?> method_16772() {
        return ModRegistry.WOOL_REPLACING_PROCESSOR.get();
    }
}

