/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.math;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataCache;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.api.objects.data.DhApiRaycastResult;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import nx.pingwheel.common.CommonClient;

public class Raycast {
    private static IDhApiTerrainDataCache terrainCache = null;
    private static Instant lastCacheLoad = Instant.EPOCH;

    private Raycast() {
    }

    public static void traceDistantAsync(class_243 direction, float tickDelta, Consumer<class_3965> callback) {
        class_1297 cameraEntity = CommonClient.Game.field_1719;
        if (cameraEntity == null || cameraEntity.method_37908() == null) {
            return;
        }
        class_243 rayStartVec = cameraEntity.method_5836(tickDelta);
        CompletableFuture<class_3965> ft = CompletableFuture.supplyAsync(() -> {
            if (DhApi.Delayed.worldProxy == null) {
                return null;
            }
            IDhApiLevelWrapper levelWrapper = DhApi.Delayed.worldProxy.getSinglePlayerLevel();
            if (levelWrapper == null) {
                return null;
            }
            if (terrainCache == null || Duration.between(lastCacheLoad, Instant.now()).getSeconds() > 10L) {
                terrainCache = DhApi.Delayed.terrainRepo.createSoftCache();
                lastCacheLoad = Instant.now();
            }
            DhApiResult rayCastResult = DhApi.Delayed.terrainRepo.raycast(levelWrapper, rayStartVec.field_1352, rayStartVec.field_1351, rayStartVec.field_1350, (float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350, 4096, terrainCache);
            if (!rayCastResult.success || rayCastResult.payload == null) {
                return null;
            }
            class_243 pos = new class_243((double)((DhApiRaycastResult)rayCastResult.payload).pos.x, (double)((DhApiRaycastResult)rayCastResult.payload).pos.y, (double)((DhApiRaycastResult)rayCastResult.payload).pos.z);
            return new class_3965(pos, class_2350.field_11036, new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), true);
        });
        ft.thenAccept(result -> Optional.ofNullable(result).ifPresent(callback));
    }

    public static class_239 traceDirectional(class_243 direction, float tickDelta, double maxDistance, boolean hitTranslucent) {
        class_1297 cameraEntity = CommonClient.Game.field_1719;
        if (cameraEntity == null || cameraEntity.method_37908() == null) {
            return null;
        }
        class_243 rayStartVec = cameraEntity.method_5836(tickDelta);
        class_243 rayEndVec = rayStartVec.method_1019(direction.method_1021(maxDistance));
        class_238 boundingBox = cameraEntity.method_5829().method_18804(cameraEntity.method_5828(1.0f).method_1021(maxDistance)).method_1009(1.0, 1.0, 1.0);
        class_3965 blockHitResult = cameraEntity.method_37908().method_17742(new class_3959(rayStartVec, rayEndVec, hitTranslucent ? class_3959.class_3960.field_17559 : class_3959.class_3960.field_23142, hitTranslucent ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, cameraEntity));
        class_3966 entityHitResult = Raycast.traceEntity(cameraEntity, rayStartVec, rayEndVec, boundingBox, targetEntity -> !targetEntity.method_7325());
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (rayStartVec.method_1025(blockHitResult.method_17784()) < rayStartVec.method_1025(entityHitResult.method_17784())) {
            return blockHitResult;
        }
        return entityHitResult;
    }

    private static class_3966 traceEntity(class_1297 entity, class_243 min, class_243 max, class_238 box, Predicate<class_1297> predicate) {
        double minDist = min.method_1025(max);
        class_3966 minHitResult = null;
        for (class_1297 ent : entity.method_37908().method_8333(entity, box, predicate)) {
            class_3966 hitResult;
            double hitDist;
            class_238 targetBoundingBox = ent.method_5829().method_1014((double)ent.method_5871()).method_1014(0.25);
            Optional hitPos = targetBoundingBox.method_992(min, max);
            if (hitPos.isEmpty() || !(minDist > (hitDist = min.method_1025((hitResult = new class_3966(ent, (class_243)hitPos.get())).method_17784())))) continue;
            minDist = hitDist;
            minHitResult = hitResult;
        }
        return minHitResult;
    }
}

