/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.levelgen;

import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7145;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.betterx.worlds.together.biomesource.config.BiomeSourceConfig;
import org.betterx.worlds.together.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.worlds.together.tag.v3.CommonBiomeTags;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;

class BiomeRepairHelper {
    private Map<class_5321<class_5363>, class_2794> vanillaDimensions = null;

    BiomeRepairHelper() {
    }

    public class_2378<class_5363> repairBiomeSourceInAllDimensions(class_5455 registryAccess, class_2378<class_5363> dimensionRegistry) {
        Map<class_5321<class_5363>, class_2794> dimensions = TogetherWorldPreset.loadWorldDimensions();
        for (Map.Entry entry : dimensionRegistry.method_29722()) {
            class_1966 class_19662;
            boolean didRepair = false;
            class_5321 key = (class_5321)entry.getKey();
            class_5363 loadedStem = (class_5363)entry.getValue();
            class_2794 referenceGenerator = dimensions.get(key);
            if (referenceGenerator instanceof EnforceableChunkGenerator) {
                EnforceableChunkGenerator enforcer = (EnforceableChunkGenerator)referenceGenerator;
                class_2794 loadedChunkGenerator = loadedStem.comp_1013();
                this.processBiomeTagsForDimension((class_5321<class_5363>)key);
                this.registerAllBiomesFromVanillaDimension((class_5321<class_5363>)key);
                if (enforcer.togetherShouldRepair(loadedChunkGenerator)) {
                    dimensionRegistry = enforcer.enforceGeneratorInWorldGenSettings(registryAccess, (class_5321<class_5363>)key, (class_5321<class_2874>)((class_5321)loadedStem.comp_1012().method_40230().orElseThrow()), loadedChunkGenerator, dimensionRegistry);
                    didRepair = true;
                } else {
                    class_1966 class_19663 = loadedChunkGenerator.method_12098();
                    if (class_19663 instanceof BiomeSourceWithConfig) {
                        BiomeSourceWithConfig refSource;
                        BiomeSourceWithConfig lodedSource = (BiomeSourceWithConfig)class_19663;
                        class_1966 class_19664 = referenceGenerator.method_12098();
                        if (class_19664 instanceof BiomeSourceWithConfig && !(refSource = (BiomeSourceWithConfig)class_19664).getTogetherConfig().sameConfig((BiomeSourceConfig<?>)lodedSource.getTogetherConfig())) {
                            lodedSource.setTogetherConfig(refSource.getTogetherConfig());
                        }
                    }
                }
            }
            if (didRepair || !((class_19662 = loadedStem.comp_1013().method_12098()) instanceof ReloadableBiomeSource)) continue;
            ReloadableBiomeSource reload = (ReloadableBiomeSource)class_19662;
            reload.reloadBiomes();
        }
        return dimensionRegistry;
    }

    private void processBiomeTagsForDimension(class_5321<class_5363> key) {
        if (key.equals((Object)class_5363.field_25413)) {
            this.preprocessBiomeTags((class_6862<class_1959>)class_6908.field_36518, BiomeAPI.BiomeType.NETHER);
        } else if (key.equals((Object)class_5363.field_25414)) {
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_HIGHLAND, BiomeAPI.BiomeType.END_LAND);
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_MIDLAND, BiomeAPI.BiomeType.END_LAND);
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_BARRENS, BiomeAPI.BiomeType.END_BARRENS);
            this.preprocessBiomeTags(CommonBiomeTags.IS_SMALL_END_ISLAND, BiomeAPI.BiomeType.END_VOID);
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_CENTER, BiomeAPI.BiomeType.END_CENTER);
            this.preprocessBiomeTags((class_6862<class_1959>)class_6908.field_37394, BiomeAPI.BiomeType.END_LAND);
        }
    }

    private void preprocessBiomeTags(class_6862<class_1959> tag, BiomeAPI.BiomeType targetType) {
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            WorldBootstrap.getLastRegistryAccess().method_33310(tag.comp_326()).map(r -> r.method_40286(tag)).ifPresent(iter -> {
                for (class_6880 biomeHolder : iter) {
                    BCLBiomeRegistry.registerIfUnknown((class_6880<class_1959>)biomeHolder, targetType);
                }
            });
        }
    }

    private void registerAllBiomesFromVanillaDimension(class_5321<class_5363> key) {
        BiomeAPI.BiomeType type = BiomeAPI.BiomeType.getMainBiomeTypeForDimension(key);
        if (type != null) {
            class_2794 vanillaDim;
            if (this.vanillaDimensions == null) {
                this.vanillaDimensions = TogetherWorldPreset.getDimensionsMap((class_5321<class_7145>)class_5317.field_25050);
            }
            if ((vanillaDim = (class_2794)this.vanillaDimensions.getOrDefault(key, null)) != null && vanillaDim.method_12098() != null) {
                for (class_6880 biomeHolder : vanillaDim.method_12098().method_28443()) {
                    BCLBiomeRegistry.registerIfUnknown((class_6880<class_1959>)biomeHolder, type);
                }
            }
        }
    }
}

