/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.mojang.serialization.Codec;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5847;
import net.minecraft.class_6862;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_7059;
import net.minecraft.class_7891;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.worlds.together.tag.v3.TagManager;

abstract class BCLBaseStructureBuilder<S extends class_3195, T extends BCLBaseStructureBuilder<S, T>> {
    static final ConcurrentLinkedQueue<BCLStructure.Unbound<?>> UNBOUND_STRUCTURES = new ConcurrentLinkedQueue();
    static final ConcurrentLinkedQueue<BCLStructure.Unbound<?>> UNBOUND_STRUCTURE_SETS = new ConcurrentLinkedQueue();
    protected final class_2960 structureID;
    protected BCLStructure.StructureBuilder<S> structureBuilder;
    private class_2893.class_2895 step;
    private class_6874 placement;
    private class_6862<class_1959> biomeTag;
    private class_5847 terrainAdjustment;

    protected BCLBaseStructureBuilder(class_2960 structureID, BCLStructure.StructureBuilder<S> structureBuilder) {
        this.structureID = structureID;
        this.structureBuilder = structureBuilder;
        this.step = class_2893.class_2895.field_13173;
        this.terrainAdjustment = class_5847.field_28922;
        this.placement = null;
        this.biomeTag = null;
    }

    public T adjustment(class_5847 value) {
        this.terrainAdjustment = value;
        return (T)this;
    }

    public T step(class_2893.class_2895 value) {
        this.step = value;
        return (T)this;
    }

    public T placement(class_6874 value) {
        this.placement = value;
        return (T)this;
    }

    public T randomPlacement(int spacing, int separation) {
        this.placement = new class_6872(spacing, separation, class_6873.field_36421, 13323129 + spacing + separation + this.structureID.toString().hashCode() % 10000);
        return (T)this;
    }

    public T biomeTag(String modID, String path) {
        this.biomeTag = TagManager.BIOMES.makeStructureTag(modID, path);
        return (T)this;
    }

    public T biomeTag(class_6862<class_1959> tag) {
        this.biomeTag = tag;
        return (T)this;
    }

    protected abstract Codec<S> getCodec();

    public BCLStructure<S> build() {
        if (this.placement == null) {
            throw new IllegalStateException("Placement needs to be defined for " + this.structureID);
        }
        if (this.structureBuilder == null) {
            throw new IllegalStateException("A structure builder needs to be defined for " + this.structureID);
        }
        if (this.biomeTag == null) {
            this.biomeTag(this.structureID.method_12836(), this.structureID.method_12832());
        }
        BCLStructure.Unbound<S> res = new BCLStructure.Unbound<S>(this.structureID, this.step, this.placement, this.getCodec(), this.biomeTag, this.structureBuilder, this.terrainAdjustment);
        UNBOUND_STRUCTURES.add(res);
        UNBOUND_STRUCTURE_SETS.add(res);
        return res;
    }

    static void registerUnbound(class_7891<class_3195> context) {
        UNBOUND_STRUCTURES.forEach((Consumer<BCLStructure.Unbound<?>>)((Consumer<BCLStructure.Unbound>)s -> s.register(context)));
        UNBOUND_STRUCTURES.clear();
    }

    static void registerUnboundSets(class_7891<class_7059> context) {
        UNBOUND_STRUCTURE_SETS.forEach((Consumer<BCLStructure.Unbound<?>>)((Consumer<BCLStructure.Unbound>)s -> s.registerSet(context)));
        UNBOUND_STRUCTURE_SETS.clear();
    }
}

