/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Rhino
extends NaturalistAnimal
implements NaturalistGeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> CHARGE_COOLDOWN_TICKS = class_2945.method_12791(Rhino.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_TARGET = class_2945.method_12791(Rhino.class, (class_2941)class_2943.field_13323);
    private int stunnedTick;
    private boolean canBePushed = true;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.run");
    protected static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.sf_nba.rhino.attack");
    protected static final RawAnimation FOOT = RawAnimation.begin().thenPlay("animation.sf_nba.rhino.foot");
    protected static final RawAnimation STUNNED = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.stunned");

    public Rhino(class_1299<? extends NaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, 0.6).method_26868(class_5134.field_23717, 12.0);
    }

    public class_1315 method_5943(class_5425 pLevel, class_1266 pDifficulty, class_3730 pReason, @Nullable class_1315 pSpawnData, @Nullable class_2487 pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new class_1296.class_4697(1.0f);
        }
        return super.method_5943(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new RhinoMeleeAttackGoal((class_1314)this, 1.2, false));
        this.field_6201.method_6277(2, (class_1352)new RhinoPrepareChargeGoal(this));
        this.field_6201.method_6277(3, (class_1352)new RhinoChargeGoal(this, 2.5));
        this.field_6201.method_6277(3, (class_1352)new BabyPanicGoal((class_1314)this, 2.0));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new BabyHurtByTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new RhinoNearestAttackablePlayerTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1309.class, 0, false, false, p_213619_0_ -> p_213619_0_.method_6118(class_1304.field_6169).method_7909() == class_1802.field_17519));
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)NaturalistEntityTypes.RHINO.get().method_5883((class_1937)serverLevel);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHARGE_COOLDOWN_TICKS, (Object)0);
        this.field_6011.method_12784(HAS_TARGET, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("StunTick", this.stunnedTick);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.stunnedTick = compound.method_10550("StunTick");
    }

    public void setChargeCooldownTicks(int ticks) {
        this.field_6011.method_12778(CHARGE_COOLDOWN_TICKS, (Object)ticks);
    }

    public int getChargeCooldownTicks() {
        return (Integer)this.field_6011.method_12789(CHARGE_COOLDOWN_TICKS);
    }

    public boolean hasChargeCooldown() {
        return (Integer)this.field_6011.method_12789(CHARGE_COOLDOWN_TICKS) > 0;
    }

    public void resetChargeCooldownTicks() {
        this.field_6011.method_12778(CHARGE_COOLDOWN_TICKS, (Object)50);
    }

    public void setHasTarget(boolean hasTarget) {
        this.field_6011.method_12778(HAS_TARGET, (Object)hasTarget);
    }

    public boolean hasTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_TARGET);
    }

    public int method_5986() {
        return this.method_5624() ? 1 : 50;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_5805()) {
            return;
        }
        this.method_5996(class_5134.field_23719).method_6192(this.method_6062() ? 0.0 : 0.2);
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
        }
    }

    private void stunEffect() {
        if (this.field_5974.method_43048(6) == 0) {
            double d = this.method_23317() - (double)this.method_17681() * Math.sin(this.field_6283 * ((float)Math.PI / 180)) + (this.field_5974.method_43058() * 0.6 - 0.3);
            double e = this.method_23318() + (double)this.method_17682() - 0.3;
            double f = this.method_23321() + (double)this.method_17681() * Math.cos(this.field_6283 * ((float)Math.PI / 180)) + (this.field_5974.method_43058() * 0.6 - 0.3);
            this.method_37908().method_8406((class_2394)class_2398.field_11226, d, e, f, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected boolean method_6062() {
        return super.method_6062() || this.stunnedTick > 0;
    }

    protected void method_6060(class_1309 defender) {
        this.stunnedTick = 60;
        this.resetChargeCooldownTicks();
        this.method_5942().method_6340();
        this.method_5783(class_3417.field_14822, 1.0f, 1.0f);
        this.method_37908().method_8421((class_1297)this, (byte)39);
        defender.method_5697((class_1297)this);
        defender.field_6037 = true;
    }

    public void method_5711(byte id) {
        if (id == 39) {
            this.stunnedTick = 60;
        }
        super.method_5711(id);
    }

    public void method_5958() {
        if (this.method_5962().method_6241()) {
            this.method_5728(this.method_5962().method_6242() >= 1.5);
        } else {
            this.method_5728(false);
        }
        super.method_5958();
    }

    private boolean isWithinYRange(class_1309 target) {
        if (target == null) {
            return false;
        }
        return Math.abs(target.method_23318() - this.method_23318()) < 3.0;
    }

    public boolean method_5810() {
        return this.canBePushed;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_6109() ? NaturalistSoundEvents.RHINO_AMBIENT_BABY.get() : NaturalistSoundEvents.RHINO_AMBIENT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Rhino> PlayState predicate(AnimationState<E> event) {
        if (this.stunnedTick > 0) {
            event.getController().setAnimation(STUNNED);
            event.getController().setAnimationSpeed(1.0);
        } else if (event.isMoving()) {
            if (this.method_5624()) {
                event.getController().setAnimation(RUN);
                event.getController().setAnimationSpeed(3.0);
            } else {
                event.getController().setAnimation(WALK);
                event.getController().setAnimationSpeed(1.0);
            }
        } else if (this.hasChargeCooldown() && this.hasTarget()) {
            event.getController().setAnimation(FOOT);
            event.getController().setAnimationSpeed(1.0);
        } else {
            event.getController().setAnimation(IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private void soundListener(SoundKeyframeEvent<Rhino> event) {
        Rhino rhino = (Rhino)event.getAnimatable();
        if (rhino.method_37908().field_9236 && event.getKeyframeData().getSound().equals("scrape")) {
            rhino.method_37908().method_8486(rhino.method_23317(), rhino.method_23318(), rhino.method_23321(), NaturalistSoundEvents.RHINO_SCRAPE.get(), rhino.method_5634(), 1.0f, rhino.method_6017(), false);
        }
    }

    private <E extends Rhino> PlayState attackPredicate(AnimationState<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.setAnimation(ATTACK);
            event.getController().setAnimationSpeed((double)1.3f);
            event.getController().forceAnimationReset();
        }
        this.field_6252 = false;
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate)});
    }

    static class RhinoMeleeAttackGoal
    extends class_1366 {
        public RhinoMeleeAttackGoal(class_1314 pathfinderMob, double speedModifier, boolean followEvenIfNotSeen) {
            super(pathfinderMob, speedModifier, followEvenIfNotSeen);
        }

        public boolean method_6264() {
            class_1309 target = this.field_6503.method_5968();
            if (target instanceof class_1657) {
                return false;
            }
            return super.method_6264();
        }

        public void method_6270() {
            super.method_6270();
            this.field_6503.field_6252 = false;
        }
    }

    static class RhinoPrepareChargeGoal
    extends class_1352 {
        protected final Rhino rhino;

        public RhinoPrepareChargeGoal(Rhino rhino) {
            this.rhino = rhino;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.rhino.method_5968();
            if (target == null || !target.method_5805() || this.rhino.stunnedTick > 0 || !this.rhino.isWithinYRange(target)) {
                this.rhino.resetChargeCooldownTicks();
                return false;
            }
            return target instanceof class_1657 && this.rhino.hasChargeCooldown();
        }

        public void method_6269() {
            class_1309 target = this.rhino.method_5968();
            if (target == null) {
                return;
            }
            this.rhino.setHasTarget(true);
            this.rhino.resetChargeCooldownTicks();
            this.rhino.canBePushed = false;
        }

        public void method_6270() {
            this.rhino.setHasTarget(false);
            this.rhino.canBePushed = true;
        }

        public void method_6268() {
            class_1309 target = this.rhino.method_5968();
            if (target == null) {
                return;
            }
            this.rhino.method_5988().method_35111((class_1297)target);
            this.rhino.setChargeCooldownTicks(Math.max(0, this.rhino.getChargeCooldownTicks() - 1));
        }
    }

    static class RhinoChargeGoal
    extends class_1352 {
        protected final Rhino mob;
        private final double speedModifier;
        @Nullable
        private class_11 path;
        private class_243 chargeDirection;

        public RhinoChargeGoal(Rhino pathfinderMob, double speedModifier) {
            this.mob = pathfinderMob;
            this.speedModifier = speedModifier;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.chargeDirection = class_243.field_1353;
        }

        public boolean method_6264() {
            class_1309 target = this.mob.method_5968();
            if (target == null || !target.method_5805() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            this.path = this.mob.method_5942().method_6349((class_1297)target, 0);
            return target instanceof class_1657 && this.path != null;
        }

        public boolean method_6266() {
            class_1309 target = this.mob.method_5968();
            if (target == null || !target.method_5805() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            return !this.mob.method_5942().method_6357();
        }

        public void method_6269() {
            class_2338 blockPosition = this.mob.method_24515();
            class_2338 target = this.path.method_48();
            this.chargeDirection = new class_243((double)(blockPosition.method_10263() - target.method_10263()), 0.0, (double)(blockPosition.method_10260() - target.method_10260())).method_1029();
            this.mob.method_5942().method_6334(this.path, this.speedModifier);
            this.mob.method_19540(true);
        }

        public void method_6270() {
            this.mob.resetChargeCooldownTicks();
            this.mob.method_5942().method_6340();
            this.mob.field_6252 = false;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            this.mob.method_5988().method_19615(class_243.method_24953((class_2382)this.path.method_48()));
            if (this.mob.field_5976 && this.mob.method_24828()) {
                this.mob.method_6043();
            }
            if (this.mob.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                class_238 boundingBox = this.mob.method_5829().method_1014(0.2);
                for (class_2338 pos : class_2338.method_10094((int)class_3532.method_15357((double)boundingBox.field_1323), (int)class_3532.method_15357((double)boundingBox.field_1322), (int)class_3532.method_15357((double)boundingBox.field_1321), (int)class_3532.method_15357((double)boundingBox.field_1320), (int)class_3532.method_15357((double)boundingBox.field_1325), (int)class_3532.method_15357((double)boundingBox.field_1324))) {
                    class_2680 state = this.mob.method_37908().method_8320(pos);
                    if (!state.method_26164(NaturalistTags.BlockTags.RHINO_CHARGE_BREAKABLE)) continue;
                    this.mob.method_37908().method_8651(pos, true, (class_1297)this.mob);
                }
            }
            if (!this.mob.method_37908().method_8608()) {
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_17430, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), 5, (double)(this.mob.method_17681() / 4.0f), 0.0, (double)(this.mob.method_17681() / 4.0f), 0.01);
            }
            if (this.mob.method_37908().method_8510() % 2L == 0L) {
                this.mob.method_5783(class_3417.field_22262, 0.5f, this.mob.method_6017());
            }
            this.tryToHurt();
        }

        protected void tryToHurt() {
            class_1309 livingEntity;
            List nearbyEntities = this.mob.method_37908().method_18466(class_1309.class, class_4051.method_36625(), (class_1309)this.mob, this.mob.method_5829());
            if (!nearbyEntities.isEmpty() && !((livingEntity = (class_1309)nearbyEntities.get(0)) instanceof Rhino)) {
                livingEntity.method_5643(livingEntity.method_48923().method_48812((class_1309)this.mob), (float)this.mob.method_26825(class_5134.field_23721));
                float speed = class_3532.method_15363((float)(this.mob.method_6029() * 1.65f), (float)0.2f, (float)3.0f);
                float shieldBlockModifier = livingEntity.method_6061(livingEntity.method_48923().method_48812((class_1309)this.mob)) ? 0.5f : 1.0f;
                livingEntity.method_6005((double)(shieldBlockModifier * speed) * 2.0, this.chargeDirection.method_10216(), this.chargeDirection.method_10215());
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.method_26825(class_5134.field_23718));
                livingEntity.method_18799(livingEntity.method_18798().method_1031(0.0, (double)0.4f * knockbackResistance, 0.0));
                this.mob.method_6104(class_1268.field_5808);
                if (livingEntity.equals((Object)this.mob.method_5968())) {
                    this.method_6270();
                }
            }
        }
    }

    static class RhinoNearestAttackablePlayerTargetGoal
    extends class_1400<class_1657> {
        private final Rhino rhino;

        public RhinoNearestAttackablePlayerTargetGoal(Rhino mob) {
            super((class_1308)mob, class_1657.class, 10, true, true, class_1301.field_6156::test);
            this.rhino = mob;
        }

        public boolean method_6264() {
            if (this.rhino.method_6109()) {
                return false;
            }
            if (super.method_6264()) {
                if (!this.rhino.isWithinYRange(this.field_6644)) {
                    return false;
                }
                List nearbyEntities = this.rhino.method_37908().method_18467(Rhino.class, this.rhino.method_5829().method_1009(8.0, 4.0, 8.0));
                for (Rhino mob : nearbyEntities) {
                    if (!mob.method_6109()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

