/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.config.FaunifyConfig;
import com.pepper.faunify.entity.FennecEntity;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class FennecModel
extends GeoModel<FennecEntity> {
    public class_2960 getModelResource(FennecEntity animatable) {
        return new class_2960("faunify", "geo/fennec.geo.json");
    }

    public class_2960 getTextureResource(FennecEntity animatable) {
        return new class_2960("faunify", "textures/entity/fennec.png");
    }

    public class_2960 getAnimationResource(FennecEntity animatable) {
        if (FaunifyConfig.oldAnimationStyle) {
            return new class_2960("faunify", "animations/fennec.animation.json");
        }
        return new class_2960("faunify", "animations/ratfennec.animation.json");
    }

    public void setCustomAnimations(FennecEntity entity, long instanceId, AnimationState<FennecEntity> animationState) {
        if (animationState == null) {
            return;
        }
        CoreGeoBone head = this.getBone("head").orElse(null);
        CoreGeoBone neck = this.getBone("head_rotation").orElse(null);
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (entityData == null) {
            return;
        }
        boolean moving = animationState.isMoving();
        if (head != null) {
            if (entity.method_6109()) {
                float headScale = 1.3f;
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            } else {
                head.setScaleX(1.0f);
                head.setScaleY(1.0f);
                head.setScaleZ(1.0f);
            }
        }
        if (!entity.method_6113() && head != null) {
            if (entity.method_6172()) {
                head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(head.getRotY() + entityData.netHeadYaw() * ((float)Math.PI / 180));
            } else {
                head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
            }
        }
        if (neck != null && head != null && !entity.method_6113() && !entity.method_6172()) {
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

