/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify;

import com.pepper.faunify.config.FaunifyConfig;
import com.pepper.faunify.event.CreativeTabHandler;
import com.pepper.faunify.items.tabs.FaunifyCreativeTabs;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifyParticles;
import com.pepper.faunify.registry.FaunifySounds;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Faunify
implements ModInitializer {
    public static final String MODID = "faunify";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"faunify");

    public void onInitialize() {
        LOGGER.info("Initializing Faunify...");
        FaunifyConfig.load();
        FaunifyItems.register();
        FaunifyBlocks.register();
        FaunifySounds.register();
        FaunifyEntities.register();
        FaunifyParticles.register();
        FaunifyCreativeTabs.register();
        FaunifyEntities.registerSpawnPlacements();
        FaunifyEntities.addBiomeSpawns();
        CreativeTabHandler.register();
        System.setProperty("logging.level.software.bernie.geckolib", "ERROR");
        Faunify.suppressSTDOUT();
        LOGGER.info("Faunify initialized successfully!");
    }

    private static void suppressSTDOUT() {
        final PrintStream originalOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String output = new String(b, off, len);
                if (!output.contains("Unable to find animation:")) {
                    originalOut.write(b, off, len);
                }
            }
        }));
    }
}

