using UnityEngine;

public class Gamelogic : MonoBehaviour
{
    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        for (int i = 0; i < 4; i++)
        {
            GameObject plane = GameObject.CreatePrimitive(PrimitiveType.Plane);

            var rotate = plane.transform.eulerAngles;
            rotate.x = 90 * i;
            plane.transform.rotation = Quaternion.Euler(rotate);

            var scale = plane.transform.localScale;
            scale.x = 25f;
            plane.transform.localScale = scale;

            var location = plane.transform.position;
            if (i % 2 == 0)
            {
                plane.GetComponent<Renderer>().material.color = Color.green;
                location.y = 5f * (i-1);
            } else
            {
                plane.GetComponent<Renderer>().material.color = Color.red;
                location.z = 5f * (i-2);
            }
            plane.transform.position = location;
        }
    }

    // Update is called once per frame
    void Update()
    {
        
    }
}
