/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class DoubleData
extends AbstractData<Double>
implements IContainerData {
    private double _lastValue;

    public static DoubleData immutable(ModContainer container, boolean isClientSide, double value) {
        return DoubleData.of(container, isClientSide, (NonNullSupplier<Supplier<Double>>)((NonNullSupplier)() -> () -> value));
    }

    public static DoubleData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Double>> serverSideGetter) {
        return DoubleData.of(container, isClientSide, (NonNullSupplier<Supplier<Double>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static DoubleData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Double>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        DoubleData data = isClientSide ? new DoubleData() : new DoubleData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static DoubleData of(ModContainer container, boolean isClientSide, double[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        DoubleData data = DoubleData.of(container, isClientSide, (NonNullSupplier<Supplier<Double>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        double current = (Double)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeDouble(current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.readDouble());
    }

    @Override
    @Nullable
    public Double defaultValue() {
        return 0.0;
    }

    private DoubleData() {
    }

    private DoubleData(NonNullSupplier<Supplier<Double>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = 0.0;
    }
}

