/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;

public class ConditionBuilder {
    private final NonNullConsumer<Condition> _sink;
    private Condition _condition;

    static Condition root(NonNullConsumer<ConditionBuilder> rootConditionBuilder) {
        ObjectArrayList conditions = new ObjectArrayList(16);
        ConditionBuilder builder = new ConditionBuilder((NonNullConsumer<Condition>)((NonNullConsumer)arg_0 -> ConditionBuilder.lambda$root$0((List)conditions, arg_0)));
        rootConditionBuilder.accept((Object)builder);
        if (conditions.isEmpty()) {
            throw new IllegalStateException("No Condition were added by this builder");
        }
        return (Condition)conditions.get(0);
    }

    static List<Condition> nested(NonNullConsumer<ConditionBuilder> nestedConditionBuilder) {
        ObjectArrayList conditions = new ObjectArrayList(16);
        ConditionBuilder builder = new ConditionBuilder((NonNullConsumer<Condition>)((NonNullConsumer)((List)conditions)::add));
        nestedConditionBuilder.accept((Object)builder);
        if (conditions.isEmpty()) {
            throw new IllegalStateException("No Condition were added by this builder");
        }
        return conditions;
    }

    public void build() {
        Preconditions.checkState((null != this._condition ? 1 : 0) != 0, (Object)"No Condition to build");
        this._sink.accept((Object)this._condition);
        this._condition = null;
    }

    public ConditionBuilder and(NonNullConsumer<ConditionBuilder> nestedConditionBuilder) {
        return this.composite((NonNullFunction<Condition[], Condition>)((NonNullFunction)Condition::m_176293_), nestedConditionBuilder);
    }

    public ConditionBuilder or(NonNullConsumer<ConditionBuilder> nestedConditionBuilder) {
        return this.composite((NonNullFunction<Condition[], Condition>)((NonNullFunction)Condition::m_125137_), nestedConditionBuilder);
    }

    public <T extends Comparable<T>> ConditionBuilder match(Property<T> property, T value) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().m_125176_(property, value);
        return this;
    }

    @SafeVarargs
    public final <T extends Comparable<T>> ConditionBuilder match(Property<T> property, T value, T ... otherValues) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().m_125179_(property, value, otherValues);
        return this;
    }

    public <T extends Comparable<T>> ConditionBuilder dontMatch(Property<T> property, T value) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().m_176296_(property, value);
        return this;
    }

    @SafeVarargs
    public final <T extends Comparable<T>> ConditionBuilder dontMatch(Property<T> property, T value, T ... otherValues) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().m_176299_(property, value, otherValues);
        return this;
    }

    private ConditionBuilder(NonNullConsumer<Condition> conditionSink) {
        this._sink = conditionSink;
    }

    private ConditionBuilder composite(NonNullFunction<Condition[], Condition> factory, NonNullConsumer<ConditionBuilder> nestedConditionBuilder) {
        Preconditions.checkNotNull(nestedConditionBuilder);
        this._condition = (Condition)factory.apply((Object)((Condition[])ConditionBuilder.nested(nestedConditionBuilder).toArray(Condition[]::new)));
        return this;
    }

    private Condition.TerminalCondition getCurrentTerminalConditionOrThrow() {
        if (null == this._condition) {
            Condition.TerminalCondition condition = Condition.m_125135_();
            this._condition = condition;
            return condition;
        }
        if (!(this._condition instanceof Condition.TerminalCondition)) {
            throw new IllegalStateException("A non-terminal Condition is already being build");
        }
        return (Condition.TerminalCondition)this._condition;
    }

    private static /* synthetic */ void lambda$root$0(List conditions, Condition condition) {
        if (!conditions.isEmpty()) {
            throw new IllegalStateException("A Condition was already added by this builder");
        }
        conditions.add(condition);
    }
}

