/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.maven;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class MavenNotation
implements Serializable {
    public final String group;
    public final String module;
    @Nullable
    public final String version;
    @Nullable
    public final String classifier;
    public final String extension;

    public MavenNotation(String group, String module, @Nullable String version, @Nullable String classifier, String extension) {
        this.group = Objects.requireNonNull(group, "group");
        this.module = Objects.requireNonNull(module, "module");
        this.version = MavenNotation.isEmpty(version) ? null : version;
        this.classifier = MavenNotation.isEmpty(classifier) ? null : classifier;
        this.extension = Objects.requireNonNull(extension, "extension");
    }

    public MavenNotation(MavenNotation other) {
        this(other.group, other.module, other.version, other.classifier, other.extension);
    }

    public static MavenNotation parse(String str) {
        String[] segs = str.split(":");
        if (segs.length > 4 || segs.length < 2) {
            throw new RuntimeException("Invalid maven string: " + str);
        }
        String ext = "jar";
        if (segs[segs.length - 1].contains("@")) {
            String s = segs[segs.length - 1];
            int at = s.indexOf("@");
            ext = s.substring(at + 1);
            segs[segs.length - 1] = s.substring(0, at);
        }
        return new MavenNotation(segs[0], segs[1], segs.length > 2 ? segs[2] : null, segs.length > 3 ? segs[3] : null, ext);
    }

    public MavenNotation withGroup(String group) {
        return new MavenNotation(group, this.module, this.version, this.classifier, this.extension);
    }

    public MavenNotation withModule(String module) {
        return new MavenNotation(this.group, module, this.version, this.classifier, this.extension);
    }

    public MavenNotation withVersion(@Nullable String version) {
        return new MavenNotation(this.group, this.module, version, this.classifier, this.extension);
    }

    public MavenNotation withClassifier(@Nullable String classifier) {
        return new MavenNotation(this.group, this.module, this.version, classifier, this.extension);
    }

    public MavenNotation withExtension(String extension) {
        return new MavenNotation(this.group, this.module, this.version, this.classifier, extension);
    }

    public String toPath() {
        Objects.requireNonNull(this.version, "Version missing");
        return this.toModulePath() + this.version + "/" + this.toFileName();
    }

    public String toFileName() {
        Objects.requireNonNull(this.version, "Version missing");
        String classifier = !MavenNotation.isEmpty(this.classifier) ? "-" + this.classifier : "";
        return this.module + "-" + this.version + classifier + "." + this.extension;
    }

    public String toModulePath() {
        return this.group.replace(".", "/") + "/" + this.module + "/";
    }

    public File toFile(File dir) {
        return new File(dir, this.toPath());
    }

    public Path toPath(Path dir) {
        return dir.resolve(this.toPath());
    }

    public URL toURL(String repo) {
        try {
            return new URL(MavenNotation.appendIfMissing(repo, "/") + this.toPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + (!MavenNotation.isEmpty(this.version) ? this.version : "").hashCode();
        result = 31 * result + (!MavenNotation.isEmpty(this.classifier) ? this.classifier : "").hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof MavenNotation)) {
            return false;
        }
        MavenNotation other = (MavenNotation)obj;
        return Objects.equals(this.group, other.group) && Objects.equals(this.module, other.module) && Objects.equals(this.version, other.version) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.extension, other.extension);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.group);
        builder.append(":");
        builder.append(this.module);
        if (!MavenNotation.isEmpty(this.version)) {
            builder.append(":");
            builder.append(this.version);
        }
        if (!MavenNotation.isEmpty(this.classifier)) {
            builder.append(":");
            builder.append(this.classifier);
        }
        if (!Objects.equals(this.extension, "jar")) {
            builder.append("@");
            builder.append(this.extension);
        }
        return builder.toString();
    }

    private static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private static String appendIfMissing(String str, String end) {
        if (!str.endsWith(end)) {
            return str + end;
        }
        return str;
    }
}

