/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.core.api;

import java.util.HashMap;
import net.minecraftforge.fml.ModLoadingContext;

public final class APIRegistry {
    private static final APIRegistry API = new APIRegistry();
    private final HashMap<Class<?>, Object> REGISTERED = new HashMap();
    private boolean frozen = false;

    static APIRegistry getAPI() {
        return API;
    }

    public static void freezeAll() {
        API.freeze();
    }

    public static <T> void registerAccess(Class<T> tClass, T object) {
        if (!ModLoadingContext.get().getActiveContainer().getModId().equals("tiab")) {
            throw new IllegalArgumentException("Mod %s tried to register to Time in a bottle's API Registry. Only used internally".formatted(ModLoadingContext.get().getActiveContainer().getModId()));
        }
        API.register(tClass, object);
    }

    <T> T getRegistered(Class<T> tClass) {
        if (this.REGISTERED.containsKey(tClass)) {
            return (T)this.REGISTERED.get(tClass);
        }
        return null;
    }

    void freeze() {
        this.frozen = true;
    }

    <T> void register(Class<T> tClass, T value) {
        if (this.frozen) {
            return;
        }
        this.REGISTERED.computeIfAbsent(tClass, i -> value);
    }
}

