/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.module.FilterModule;
import com.yogpc.qp.machines.module.FilterModuleMenu;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilterModuleItem
extends QPItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "filter_module";
    public static final String KEY_ITEMS = "filter_items";

    public FilterModuleItem() {
        super(new ResourceLocation("quarryplus", NAME), new Item.Properties().m_41487_(1));
    }

    @Override
    public QuarryModule getModule(@NotNull ItemStack stack) {
        ListTag tagList = Optional.ofNullable(stack.m_41783_()).map(t -> t.m_128437_(KEY_ITEMS, 10)).orElse(null);
        return new FilterModule(tagList);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().m_7702_(context.m_8083_()) instanceof ModuleInventory.HasModuleInventory) {
            return InteractionResult.PASS;
        }
        if (!context.m_43725_().f_46443_ && context.m_43723_() instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)context.m_43723_()), (MenuProvider)new InteractionObject(context.m_43722_()));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        super.m_7373_(stack, pLevel, tooltips, pIsAdvanced);
        tooltips.add((Component)Component.m_237115_((String)"quarryplus.tooltip.filter_module_1"));
        tooltips.add((Component)Component.m_237115_((String)"quarryplus.tooltip.filter_module_2"));
        Stream<String> keys = FilterModule.getFromTag(Optional.ofNullable(stack.m_41783_()).map(t -> t.m_128437_(KEY_ITEMS, 10)).orElse(null)).stream().map(ItemKey::getId).map(ResourceLocation::toString);
        keys.map(s -> "  " + s).map(Component::m_237113_).forEach(tooltips::add);
    }

    private record InteractionObject(ItemStack stack) implements MenuProvider
    {
        public Component m_5446_() {
            return this.stack.m_41786_();
        }

        public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
            return new FilterModuleMenu(pContainerId, pPlayer, this.stack);
        }
    }
}

