/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.util;

import com.github.almostreliable.energymeter.util.TypeEnums;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public final class TextUtils {
    private static final Locale LOCALE = Locale.getDefault();
    private static final DecimalFormat DF = (DecimalFormat)NumberFormat.getInstance(LOCALE).clone();
    private static final String[] UNITS = new String[]{"", "k", "M", "G", "T", "P"};

    private TextUtils() {
    }

    public static ResourceLocation getRL(String key) {
        return new ResourceLocation("energymeter", key);
    }

    public static String translateAsString(TypeEnums.TRANSLATE_TYPE type, String key) {
        return TextUtils.translate(type, key, new ChatFormatting[0]).getString();
    }

    public static MutableComponent translate(TypeEnums.TRANSLATE_TYPE type, String key, ChatFormatting ... color) {
        MutableComponent output = Component.m_237115_((String)TextUtils.getTranslationKey(type, key));
        return color.length == 0 ? output : output.m_130940_(color[0]);
    }

    public static MutableComponent colorize(String input, ChatFormatting color) {
        return Component.m_237113_((String)input).m_130940_(color);
    }

    public static Tuple<String, String> formatEnergy(Number number, boolean extended) {
        if (!extended) {
            int numberOfDigits = number.intValue() == 0 ? 0 : (int)(1.0 + Math.floor(Math.log10(Math.abs(number.doubleValue()))));
            int base10Exponent = numberOfDigits < 4 ? 0 : 3 * ((numberOfDigits - 1) / 3);
            double normalized = number.doubleValue() / Math.pow(10.0, base10Exponent);
            return new Tuple((Object)TextUtils.formatNumber(normalized, 2), (Object)(UNITS[base10Exponent / 3] + "FE"));
        }
        return new Tuple((Object)TextUtils.formatNumber(number, 3), (Object)"FE");
    }

    private static String getTranslationKey(TypeEnums.TRANSLATE_TYPE type, String key) {
        return String.format("%s.%s.%s", type.toString().toLowerCase(), "energymeter", key);
    }

    private static String formatNumber(Number input, int maxFraction) {
        DF.setRoundingMode(RoundingMode.DOWN);
        DF.setMinimumFractionDigits(1);
        DF.setMaximumFractionDigits(maxFraction);
        return DF.format(input);
    }
}

