/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity.core;

import com.starfish_studios.naturalist.common.helper.ItemHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistItems;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface Catchable {
    public boolean fromHand();

    public void setFromHand(boolean var1);

    public void saveToHandTag(ItemStack var1);

    public void loadFromHandTag(CompoundTag var1);

    public ItemStack getCaughtItemStack();

    public SoundEvent getPickupSound();

    @Deprecated
    public static void saveDefaultDataToHandTag(Mob mob, ItemStack hand) {
        CompoundTag compoundTag = hand.m_41784_();
        if (mob.m_8077_()) {
            hand.m_41714_(mob.m_7770_());
        }
        if (mob.m_21525_()) {
            compoundTag.m_128379_("NoAI", mob.m_21525_());
        }
        if (mob.m_20067_()) {
            compoundTag.m_128379_("Silent", mob.m_20067_());
        }
        if (mob.m_20068_()) {
            compoundTag.m_128379_("NoGravity", mob.m_20068_());
        }
        if (mob.m_146886_()) {
            compoundTag.m_128379_("Glowing", true);
        }
        if (mob.m_20147_()) {
            compoundTag.m_128379_("Invulnerable", mob.m_20147_());
        }
        compoundTag.m_128350_("Health", mob.m_21223_());
    }

    @Deprecated
    public static void loadDefaultDataFromHandTag(Mob mob, CompoundTag tag) {
        if (tag.m_128441_("NoAI")) {
            mob.m_21557_(tag.m_128471_("NoAI"));
        }
        if (tag.m_128441_("Silent")) {
            mob.m_20225_(tag.m_128471_("Silent"));
        }
        if (tag.m_128441_("NoGravity")) {
            mob.m_20242_(tag.m_128471_("NoGravity"));
        }
        if (tag.m_128441_("Glowing")) {
            mob.m_146915_(tag.m_128471_("Glowing"));
        }
        if (tag.m_128441_("Invulnerable")) {
            mob.m_20331_(tag.m_128471_("Invulnerable"));
        }
        if (tag.m_128425_("Health", 99)) {
            mob.m_21153_(tag.m_128457_("Health"));
        }
    }

    public static <T extends LivingEntity> Optional<InteractionResult> catchAnimal(Player player, InteractionHand hand, T entity, boolean needsNet) {
        ItemStack itemStack = player.m_21120_(hand);
        if ((needsNet ? itemStack.m_41720_().equals(NaturalistItems.BUG_NET.get()) : itemStack.m_41619_()) && entity.m_6084_()) {
            ItemStack caughtItemStack = ((Catchable)entity).getCaughtItemStack();
            ((Catchable)entity).saveToHandTag(caughtItemStack);
            if (needsNet) {
                itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
            }
            if (player.m_150109_().m_36054_(caughtItemStack)) {
                entity.m_146870_();
                return Optional.of(InteractionResult.SUCCESS);
            }
            ItemHelper.spawnItemOnEntity((LivingEntity)player, caughtItemStack);
            player.m_5496_(SoundEvents.f_12019_, 0.3f, 1.0f);
            if (!entity.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, caughtItemStack);
            }
            entity.m_146870_();
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }
}

