/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.block.AuroraBrickBlock;
import twilightforest.block.CastleDoorBlock;
import twilightforest.block.HollowLogClimbable;
import twilightforest.enums.HollowLogVariants;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.item.ArcticArmorItem;
import twilightforest.util.ColorUtil;

@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ColorHandler {
    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        event.register((state, getter, pos, tintIndex) -> tintIndex > 15 ? 0xFFFFFF : ColorUtil.hsvToRGB(getter == null ? 0.45f : AuroraBrickBlock.rippleFractialNoise(2, 128.0f, pos != null ? pos.m_6630_(128) : new BlockPos(0, 0, 0), 0.37f, 0.67f, 1.5f), 1.0f, 1.0f), new Block[]{(Block)TFBlocks.AURORA_BLOCK.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int normalColor = blockColors.m_92577_(((Block)TFBlocks.AURORA_BLOCK.get()).m_49966_(), getter, pos, tintIndex);
            int red = normalColor >> 16 & 0xFF;
            int blue = normalColor & 0xFF;
            int green = normalColor >> 8 & 0xFF;
            float[] hsb = ColorUtil.rgbToHSV(red, green, blue);
            return ColorUtil.hsvToRGB(hsb[0], hsb[1] * 0.5f, Math.min(hsb[2] + 0.4f, 0.9f));
        }, new Block[]{(Block)TFBlocks.AURORA_PILLAR.get(), (Block)TFBlocks.AURORA_SLAB.get(), (Block)TFBlocks.AURORALIZED_GLASS.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return FoliageColor.m_46113_();
            }
            int red = 0;
            int grn = 0;
            int blu = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int i2 = BiomeColors.m_108804_((BlockAndTintGetter)getter, (BlockPos)pos.m_7918_(dx, 0, dz));
                    red += (i2 & 0xFF0000) >> 16;
                    grn += (i2 & 0xFF00) >> 8;
                    blu += i2 & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
        }, new Block[]{(Block)TFBlocks.DARK_LEAVES.get(), (Block)TFBlocks.HARDENED_DARK_LEAVES.get(), (Block)TFBlocks.GIANT_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> tintIndex > 15 ? 0xFFFFFF : blockColors.m_92577_(Blocks.f_50034_.m_49966_(), getter, pos, tintIndex), new Block[]{(Block)TFBlocks.SMOKER.get(), (Block)TFBlocks.FIRE_JET.get()});
        event.register((state, getter, pos, tintIndex) -> getter != null && pos != null ? 2129968 : 7455580, new Block[]{(Block)TFBlocks.HUGE_LILY_PAD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return 6986775;
            }
            int fade = pos.m_123341_() * 16 + pos.m_123342_() * 16 + pos.m_123343_() * 16;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 106.0f + fall * 251.0f);
            int green = (int)(spring * 156.0f + fall * 108.0f);
            int blue = (int)(spring * 23.0f + fall * 27.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.TIME_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return 7130346;
            }
            int fade = pos.m_123341_() * 27 + pos.m_123342_() * 63 + pos.m_123343_() * 39;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 108.0f + fall * 96.0f);
            int green = (int)(spring * 204.0f + fall * 107.0f);
            int blue = (int)(spring * 234.0f + fall * 121.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.TRANSFORMATION_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return 16576836;
            }
            int fade = pos.m_123341_() * 31 + pos.m_123342_() * 33 + pos.m_123343_() * 32;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 252.0f + fall * 237.0f);
            int green = (int)(spring * 241.0f + fall * 172.0f);
            int blue = (int)(spring * 68.0f + fall * 9.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.MINING_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return 3558403;
            }
            int fade = pos.m_123341_() * 63 + pos.m_123342_() * 63 + pos.m_123343_() * 63;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 54.0f + fall * 168.0f);
            int green = (int)(spring * 76.0f + fall * 199.0f);
            int blue = (int)(spring * 3.0f + fall * 43.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.SORTING_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return -1;
            }
            float f = AuroraBrickBlock.rippleFractialNoise(2, 32.0f, pos, 0.4f, 1.0f, 2.0f);
            return ColorUtil.hsvToRGB(0.1f, 1.0f - f, (f + 2.0f) / 3.0f);
        }, new Block[]{(Block)TFBlocks.TOWERWOOD.get(), (Block)TFBlocks.CRACKED_TOWERWOOD.get(), (Block)TFBlocks.INFESTED_TOWERWOOD.get(), (Block)TFBlocks.MOSSY_TOWERWOOD.get()});
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 4764952;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        }, new Block[]{(Block)TFBlocks.TWILIGHT_OAK_LEAVES.get()});
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 6330464;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            int normalColor = (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
            return ((normalColor & 0xFEFEFE) + 4627046) / 2;
        }, new Block[]{(Block)TFBlocks.CANOPY_LEAVES.get()});
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 8431445;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            int normalColor = (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
            return ((normalColor & 0xFEFEFE) + 12641940) / 2;
        }, new Block[]{(Block)TFBlocks.MANGROVE_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (getter == null || pos == null) {
                return 4764952;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.m_108804_((BlockAndTintGetter)getter, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            red = pos.m_123341_() * 32 + pos.m_123342_() * 16;
            if ((red & 0x100) != 0) {
                red = 255 - (red & 0xFF);
            }
            red &= 0xFF;
            green = pos.m_123342_() * 32 + pos.m_123343_() * 16;
            if ((green & 0x100) != 0) {
                green = 255 - (green & 0xFF);
            }
            green ^= 0xFF;
            blue = pos.m_123341_() * 16 + pos.m_123343_() * 32;
            if ((blue & 0x100) != 0) {
                blue = 255 - (blue & 0xFF);
            }
            return red << 16 | green << 8 | (blue &= 0xFF);
        }, new Block[]{(Block)TFBlocks.RAINBOW_OAK_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> FoliageColor.m_46106_(), new Block[]{(Block)TFBlocks.BEANSTALK_LEAVES.get(), (Block)TFBlocks.THORN_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            if (getter != null && pos != null) {
                return BiomeColors.m_108804_((BlockAndTintGetter)getter, (BlockPos)pos);
            }
            return FoliageColor.m_46113_();
        }, new Block[]{(Block)TFBlocks.FALLEN_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if ((tintIndex & 1) == 1) {
                return 0xFFFFFF;
            }
            if (getter != null && pos != null) {
                return BiomeColors.m_108793_((BlockAndTintGetter)getter, (BlockPos)pos);
            }
            return GrassColor.m_46415_((double)0.5, (double)1.0);
        }, new Block[]{(Block)TFBlocks.FIDDLEHEAD.get(), (Block)TFBlocks.POTTED_FIDDLEHEAD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if ((tintIndex & 1) == 0) {
                return 0xFFFFFF;
            }
            return GrassColor.m_46415_((double)0.5, (double)1.0);
        }, new Block[]{(Block)TFBlocks.HOLLOW_OAK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_SPRUCE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_BIRCH_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_JUNGLE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_ACACIA_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_DARK_OAK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_CRIMSON_STEM_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_WARPED_STEM_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_VANGROVE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_CHERRY_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_CANOPY_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_MANGROVE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_DARK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_TIME_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_TRANSFORMATION_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_MINING_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_SORTING_LOG_HORIZONTAL.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (state.m_61143_(HollowLogClimbable.VARIANT) != HollowLogVariants.Climbable.VINE || (tintIndex & 1) == 0) {
                return 0xFFFFFF;
            }
            if (getter != null && pos != null) {
                return BiomeColors.m_108804_((BlockAndTintGetter)getter, (BlockPos)pos);
            }
            return FoliageColor.m_46113_();
        }, new Block[]{(Block)TFBlocks.HOLLOW_OAK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_SPRUCE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_BIRCH_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_JUNGLE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_ACACIA_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_DARK_OAK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_CRIMSON_STEM_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_WARPED_STEM_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_VANGROVE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_CANOPY_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_MANGROVE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_DARK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_TIME_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_TRANSFORMATION_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_MINING_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_SORTING_LOG_CLIMBABLE.get()});
        event.register((state, getter, pos, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get(), (Block)TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE.get(), (Block)TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int color = 0xFF00FF;
            if (state.m_60734_() instanceof CastleDoorBlock && ((Boolean)state.m_61143_((Property)CastleDoorBlock.ACTIVE)).booleanValue() && !((Boolean)state.m_61143_((Property)CastleDoorBlock.VANISHED)).booleanValue()) {
                return color ^ 0xFFFFFF;
            }
            return color;
        }, new Block[]{(Block)TFBlocks.PINK_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.PINK_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int color = 65535;
            if (state.m_60734_() instanceof CastleDoorBlock && ((Boolean)state.m_61143_((Property)CastleDoorBlock.ACTIVE)).booleanValue() && !((Boolean)state.m_61143_((Property)CastleDoorBlock.VANISHED)).booleanValue()) {
                return color ^ 0xFFFFFF;
            }
            return color;
        }, new Block[]{(Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.BLUE_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int color = 0xFFFF00;
            if (state.m_60734_() instanceof CastleDoorBlock && ((Boolean)state.m_61143_((Property)CastleDoorBlock.ACTIVE)).booleanValue() && !((Boolean)state.m_61143_((Property)CastleDoorBlock.VANISHED)).booleanValue()) {
                return color ^ 0xFFFFFF;
            }
            return color;
        }, new Block[]{(Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.YELLOW_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int color = 4915330;
            if (state.m_60734_() instanceof CastleDoorBlock && ((Boolean)state.m_61143_((Property)CastleDoorBlock.ACTIVE)).booleanValue() && !((Boolean)state.m_61143_((Property)CastleDoorBlock.VANISHED)).booleanValue()) {
                return color ^ 0xFFFFFF;
            }
            return color;
        }, new Block[]{(Block)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.VIOLET_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 6033524;
        }, new Block[]{(Block)TFBlocks.VIOLET_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 16385406;
        }, new Block[]{(Block)TFBlocks.PINK_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 16734978;
        }, new Block[]{(Block)TFBlocks.ORANGE_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 9037569;
        }, new Block[]{(Block)TFBlocks.GREEN_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 909055;
        }, new Block[]{(Block)TFBlocks.BLUE_FORCE_FIELD.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        event.register((stack, tintIndex) -> {
            Item patt15575$temp = stack.m_41720_();
            if (patt15575$temp instanceof BlockItem) {
                BlockItem blocc = (BlockItem)patt15575$temp;
                return blockColors.m_92577_(blocc.m_40614_().m_49966_(), null, null, tintIndex);
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)TFBlocks.AURORA_BLOCK.get(), (ItemLike)TFBlocks.AURORA_PILLAR.get(), (ItemLike)TFBlocks.AURORA_SLAB.get(), (ItemLike)TFBlocks.AURORALIZED_GLASS.get(), (ItemLike)TFBlocks.DARK_LEAVES.get(), (ItemLike)TFBlocks.GIANT_LEAVES.get(), (ItemLike)TFBlocks.SMOKER.get(), (ItemLike)TFBlocks.FIRE_JET.get(), (ItemLike)TFBlocks.TIME_LEAVES.get(), (ItemLike)TFBlocks.TRANSFORMATION_LEAVES.get(), (ItemLike)TFBlocks.MINING_LEAVES.get(), (ItemLike)TFBlocks.SORTING_LEAVES.get(), (ItemLike)TFBlocks.TWILIGHT_OAK_LEAVES.get(), (ItemLike)TFBlocks.CANOPY_LEAVES.get(), (ItemLike)TFBlocks.MANGROVE_LEAVES.get(), (ItemLike)TFBlocks.RAINBOW_OAK_LEAVES.get(), (ItemLike)TFBlocks.THORN_LEAVES.get(), (ItemLike)TFBlocks.BEANSTALK_LEAVES.get(), (ItemLike)TFBlocks.FALLEN_LEAVES.get(), (ItemLike)TFBlocks.FIDDLEHEAD.get(), (ItemLike)TFBlocks.POTTED_FIDDLEHEAD.get(), (ItemLike)TFBlocks.PINK_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.YELLOW_CASTLE_DOOR.get(), (ItemLike)TFBlocks.BLUE_CASTLE_DOOR.get(), (ItemLike)TFBlocks.PINK_CASTLE_DOOR.get(), (ItemLike)TFBlocks.VIOLET_CASTLE_DOOR.get(), (ItemLike)TFBlocks.PINK_FORCE_FIELD.get(), (ItemLike)TFBlocks.BLUE_FORCE_FIELD.get(), (ItemLike)TFBlocks.GREEN_FORCE_FIELD.get(), (ItemLike)TFBlocks.ORANGE_FORCE_FIELD.get(), (ItemLike)TFBlocks.VIOLET_FORCE_FIELD.get(), (ItemLike)TFBlocks.HUGE_LILY_PAD.get(), (ItemLike)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get(), (ItemLike)TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE.get(), (ItemLike)TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE.get()});
        event.register((stack, tintIndex) -> {
            int n;
            Item patt17707$temp = stack.m_41720_();
            if (patt17707$temp instanceof ArcticArmorItem) {
                ArcticArmorItem arctic = (ArcticArmorItem)patt17707$temp;
                n = arctic.getColor(stack, tintIndex);
            } else {
                n = 0xFFFFFF;
            }
            return n;
        }, new ItemLike[]{(ItemLike)TFItems.ARCTIC_HELMET.get(), (ItemLike)TFItems.ARCTIC_CHESTPLATE.get(), (ItemLike)TFItems.ARCTIC_LEGGINGS.get(), (ItemLike)TFItems.ARCTIC_BOOTS.get()});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : PotionUtils.m_43575_((ItemStack)stack), new ItemLike[]{(ItemLike)TFItems.BRITTLE_FLASK.get(), (ItemLike)TFItems.GREATER_FLASK.get()});
    }
}

