/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block.be;

import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.railwayteam.railways.util.ColorUtils;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SmokeStackBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    @Nullable
    protected DyeColor color = null;
    protected boolean isSoul = false;

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(@Nullable DyeColor color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.isSoul = false;
        this.notifyUpdate();
    }

    public void setSoul(boolean isSoul) {
        if (this.isSoul == isSoul) {
            return;
        }
        this.color = null;
        this.isSoul = isSoul;
        this.notifyUpdate();
    }

    public boolean isSoul() {
        return this.color == null && this.isSoul;
    }

    public SmokeStackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128425_("color", 3)) {
            int colorOrdinal = tag.m_128451_("color");
            this.color = DyeColor.m_41053_((int)colorOrdinal);
        } else {
            this.color = null;
        }
        this.isSoul = tag.m_128471_("isSoul");
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.color != null) {
            tag.m_128405_("color", this.color.m_41060_());
        }
        tag.m_128379_("isSoul", this.isSoul());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.color != null) {
            Lang.builder((String)"railways").translate("smokestack.goggle.tooltip.color", new Object[]{ColorUtils.coloredName(this.color.m_41065_())}).forGoggles(tooltip);
        }
        if (this.isSoul || this.color == null) {
            Lang.builder((String)"railways").translate("smokestack.goggle.tooltip", new Object[]{this.isSoul ? "Soul" : ColorUtils.coloredName(DyeColor.BLACK.toString())}).forGoggles(tooltip);
        }
        return true;
    }

    public ItemStack getIcon(boolean isPlayerSneaking) {
        if (this.color != null) {
            return ColorUtils.getDyeColorDyeItem(this.color).m_7968_();
        }
        return this.isSoul ? Items.f_42050_.m_7968_() : Items.f_42498_.m_7968_();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.f_58857_.m_213780_().m_188501_() < 0.11f) {
            ((SmokeStackBlock)this.m_58900_().m_60734_()).blockEntityAnimateTick(this.m_58900_(), this.f_58857_, this.m_58899_(), this.f_58857_.m_213780_());
        }
    }
}

