/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.registry.forge.CRBlockEntitiesImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FuelTankBlock
extends Block
implements IWrenchable,
IBE<FuelTankBlockEntity> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((Level)pLevel, (BlockPos)pPos, (LivingEntity)pPlacer);
    }

    public FuelTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW)));
    }

    public static boolean isTank(BlockState state) {
        return state.m_60734_() instanceof FuelTankBlock;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, FuelTankBlockEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FuelTankBlockEntity tankAt = (FuelTankBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (tankAt == null) {
            return 0;
        }
        FuelTankBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null || !controllerBE.window) {
            return 0;
        }
        return tankAt.luminosity;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), FuelTankBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        FuelTankBlockEntity controllerBE;
        Fluid fluid;
        ItemStack heldItem = player.m_21120_(hand);
        boolean onClient = world.f_46443_;
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            return InteractionResult.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        FuelTankBlockEntity be = (FuelTankBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (be == null) {
            return InteractionResult.FAIL;
        }
        LazyOptional tankCapability = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (!tankCapability.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler fluidTank = (IFluidHandler)tankCapability.orElse(null);
        FluidStack prevFluidInTank = fluidTank.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)world, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)heldItem)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInTank = tankCapability.map(fh -> fh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            fluid = fluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getEmptySound((FluidStack)fluidInTank);
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getFillSound((FluidStack)prevFluidInTank);
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.m_14036_((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FuelTankBlockEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (world.f_46441_.m_188501_() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidStackIdentical(prevFluidInTank) && be instanceof FuelTankBlockEntity && (controllerBE = be.getControllerBE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, fluidState);
                float level = (float)fluidInTank.getAmount() / (float)fluidTank.getTankCapacity(0);
                boolean reversed = fluidInTank.getFluid().getFluidType().isLighterThanAir();
                if (reversed) {
                    level = 1.0f - level;
                }
                Vec3 vec = ray.m_82450_();
                vec = new Vec3(vec.f_82479_, (double)((float)controllerBE.m_58899_().m_123342_() + level * ((float)controllerBE.height - 0.5f) + 0.25f), vec.f_82481_);
                Vec3 motion = player.m_20182_().m_82546_(vec).m_82490_((double)0.05f);
                vec = vec.m_82549_(motion);
                world.m_7106_((ParticleOptions)blockParticleData, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                return InteractionResult.SUCCESS;
            }
            controllerBE.sendDataImmediately();
            controllerBE.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof FuelTankBlockEntity)) {
                return;
            }
            FuelTankBlockEntity tankBE = (FuelTankBlockEntity)be;
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public Class<FuelTankBlockEntity> getBlockEntityClass() {
        return FuelTankBlockEntity.class;
    }

    public BlockEntityType<? extends FuelTankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntitiesImpl.FUEL_TANK.get();
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            }
            case WINDOW_NW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            }
            case WINDOW_SE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            }
            case WINDOW_SW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            }
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            }
            case WINDOW_NW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            }
            case WINDOW_SE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            }
            case WINDOW_SW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            }
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(FuelTankBlockEntity::getControllerBE).map(be -> ComparatorUtil.fractionToRedstoneLevel((double)be.getFillState())).orElse(0);
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

