/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.integration.shared.LocaleHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;

public class ManaseerMonocleItem
extends BaubleItem
implements CosmeticBauble {
    public ManaseerMonocleItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.m_237115_((String)"botaniamisc.cosmeticBauble").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        super.m_7373_(stack, world, tooltip, flags);
    }

    public static boolean hasMonocle(LivingEntity living) {
        return !EquipmentHandler.findOrEmpty(stack -> {
            if (!stack.m_41619_()) {
                Item item = stack.m_41720_();
                if (stack.m_204117_(BotaniaTags.Items.BURST_VIEWERS)) {
                    return true;
                }
                if (item instanceof CosmeticAttachable) {
                    CosmeticAttachable attach = (CosmeticAttachable)item;
                    ItemStack cosmetic = attach.getCosmeticItem((ItemStack)stack);
                    return !cosmetic.m_41619_() && cosmetic.m_204117_(BotaniaTags.Items.BURST_VIEWERS);
                }
            }
            return false;
        }, living).m_41619_();
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(0.15, -0.2, -0.25);
            ms.m_85841_(0.3f, -0.3f, -0.3f);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, light, OverlayTexture.f_118083_, ms, buffers, living.m_9236_(), living.m_19879_());
        }
    }

    public static class Hud {
        private static final int MAX_CONTENTS_COLUMNS = 9;
        private static final int MAX_CONTENTS_ROWS = 3;
        public static final int TEXT_ROW_HEIGHT = 12;

        public static void render(GuiGraphics gui, Player player) {
            EntityHitResult ehr;
            BlockHitResult bhr;
            Minecraft mc = Minecraft.m_91087_();
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).m_6662_() == HitResult.Type.BLOCK) {
                Hud.renderBlockInfo(gui, bhr, mc, player.m_9236_());
            } else if (hitResult instanceof EntityHitResult && (ehr = (EntityHitResult)hitResult).m_6662_() == HitResult.Type.ENTITY) {
                Hud.renderEntityInfo(gui, ehr, mc);
            }
        }

        private static void renderEntityInfo(GuiGraphics gui, EntityHitResult hitResult, Minecraft mc) {
            ItemFrame frame;
            Entity entity = hitResult.m_82443_();
            if (entity instanceof ItemFrame && !(frame = (ItemFrame)entity).m_31822_().m_41619_()) {
                ItemStack frameItem = frame.m_31822_();
                List<ItemStack> contentItems = FilterHelper.getFilterStacks(frameItem);
                if (contentItems.isEmpty() || contentItems.size() == 1 && ItemStack.m_150942_((ItemStack)frameItem, (ItemStack)contentItems.get(0))) {
                    return;
                }
                int x = mc.m_91268_().m_85445_() / 2 + 15;
                int y = mc.m_91268_().m_85446_() / 2 - 24;
                int maxWidth = mc.m_91268_().m_85445_() - x - 30;
                MutableComponent itemName = Component.m_237119_().m_7220_(frameItem.m_41786_()).m_130940_(frameItem.m_41791_().f_43022_);
                if (frameItem.m_41788_()) {
                    itemName.m_130940_(ChatFormatting.ITALIC);
                }
                MutableComponent text = Component.m_237110_((String)"botaniamisc.monocle.frame.contains", (Object[])new Object[]{itemName});
                List lines = mc.f_91062_.m_92923_((FormattedText)text, maxWidth);
                int textWidth = lines.stream().mapToInt(arg_0 -> ((Font)mc.f_91062_).m_92724_(arg_0)).max().orElseThrow();
                int textYOffset = (lines.size() - 1) * 12;
                int contentsWidth = Math.min(9, contentItems.size()) * 18;
                int contentsHeight = Math.min(4, (contentItems.size() - 8) / 9 + 1) * 18;
                RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + Math.max(textWidth, contentsWidth) + 24, y + textYOffset + contentsHeight + 20);
                gui.m_280480_(frameItem, x, y);
                int textRow = 0;
                for (FormattedCharSequence line : lines) {
                    gui.m_280648_(mc.f_91062_, line, x + 20, y + 12 * textRow + 4, 0xFFFFFF);
                    ++textRow;
                }
                int row = 1;
                int column = 0;
                for (ItemStack contentItem : contentItems) {
                    if (++column > 9) {
                        column = 1;
                        if (++row > 3) break;
                    }
                    gui.m_280480_(contentItem, x + 18 * column, y + 18 * row + textYOffset);
                    gui.m_280370_(mc.f_91062_, contentItem, x + 18 * column, y + 18 * row + textYOffset);
                }
                if (row > 3) {
                    MutableComponent remainingItemsHint = Component.m_237110_((String)"botaniamisc.monocle.frame.additional_stacks", (Object[])new Object[]{contentItems.size() - 27});
                    gui.m_280430_(mc.f_91062_, (Component)remainingItemsHint, x + 24, y + 18 * row + 6 + textYOffset, 0xFFFFFF);
                }
            }
        }

        private static void renderBlockInfo(GuiGraphics gui, BlockHitResult hitResult, Minecraft mc, Level level) {
            MutableComponent text;
            ItemStack dispStack;
            BlockPos pos = hitResult.m_82425_();
            BlockState state = level.m_8055_(pos);
            if (state.m_61138_((Property)BlockStateProperties.f_61426_)) {
                dispStack = new ItemStack((ItemLike)state.m_60734_());
                text = Component.m_237113_((String)((Integer)state.m_61143_((Property)BlockStateProperties.f_61426_)).toString()).m_130940_(ChatFormatting.RED);
            } else if (state.m_60713_(Blocks.f_50146_)) {
                dispStack = new ItemStack((ItemLike)Blocks.f_50146_);
                text = Component.m_237110_((String)"botaniamisc.monocle.repeater.delay", (Object[])new Object[]{LocaleHelper.formatAsDecimalFraction(0.1f * (float)((Integer)state.m_61143_((Property)RepeaterBlock.f_55798_)).intValue(), 1)});
            } else if (state.m_60713_(Blocks.f_50328_)) {
                dispStack = new ItemStack((ItemLike)Blocks.f_50328_);
                text = Component.m_237115_((String)("botaniamisc.monocle.comparator." + ((ComparatorMode)state.m_61143_((Property)ComparatorBlock.f_51854_)).m_7912_()));
            } else {
                return;
            }
            int x = mc.m_91268_().m_85445_() / 2 + 15;
            int y = mc.m_91268_().m_85446_() / 2 - 8;
            int textWidth = mc.f_91062_.m_92724_(text.m_7532_());
            RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + textWidth + 24, y + 20);
            gui.m_280480_(dispStack, x, y);
            gui.m_280430_(mc.f_91062_, (Component)text, x + 20, y + 4, 0xFFFFFF);
        }
    }
}

