/*
 * Decompiled with CFR 0.152.
 */
package giselle.gmut.common.content.gear.mekasuit;

import giselle.gmut.common.GMUTLang;
import giselle.gmut.common.content.gear.mekasuit.VerticalSpeed;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.CommonPlayerTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class ModuleGravitationalModulatingAdditionalUnit
implements ICustomModule<ModuleGravitationalModulatingAdditionalUnit> {
    private IModuleConfigItem<Boolean> flyAlways;
    private IModuleConfigItem<Boolean> stopImmediately;
    private IModuleConfigItem<Boolean> fixFOV;
    private IModuleConfigItem<VerticalSpeed> verticalSpeed;

    public void init(IModule<ModuleGravitationalModulatingAdditionalUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.flyAlways = configItemCreator.createConfigItem("fly_always", (ILangEntry)GMUTLang.MODULE_FLY_ALWAYS, (ModuleConfigData)new ModuleBooleanData(false));
        this.stopImmediately = configItemCreator.createConfigItem("stop_immediately", (ILangEntry)GMUTLang.MODULE_STOP_IMMEDIATELY, (ModuleConfigData)new ModuleBooleanData(true));
        this.fixFOV = configItemCreator.createConfigItem("fix_fov", (ILangEntry)GMUTLang.MODULE_FIX_FOV, (ModuleConfigData)new ModuleBooleanData(false));
        this.verticalSpeed = configItemCreator.createConfigItem("vertical_speed", (ILangEntry)GMUTLang.MODULE_VERTICAL_SPEED, (ModuleConfigData)new ModuleEnumData((Enum)VerticalSpeed.OFF));
    }

    public void tickServer(IModule<ModuleGravitationalModulatingAdditionalUnit> module, Player player) {
        boolean hasGravitationalModulator = CommonPlayerTickHandler.isGravitationalModulationReady((Player)player);
        if (hasGravitationalModulator && ((Boolean)this.flyAlways.get()).booleanValue() && !player.m_6144_() && !player.m_150110_().f_35935_) {
            player.m_150110_().f_35935_ = true;
            player.m_6885_();
        }
    }

    public void tickClient(IModule<ModuleGravitationalModulatingAdditionalUnit> module, Player player) {
        this.tickServer(module, player);
        boolean hasGravitationalModulator = CommonPlayerTickHandler.isGravitationalModulationReady((Player)player);
        if (hasGravitationalModulator) {
            if (((Boolean)this.stopImmediately.get()).booleanValue() && player.m_150110_().f_35935_ && player.f_20902_ == 0.0f && player.f_20900_ == 0.0f) {
                Vec3 deltaMovement = player.m_20184_();
                player.m_20256_(deltaMovement.m_82542_(0.0, 1.0, 0.0));
            }
            if (player instanceof LocalPlayer) {
                LocalPlayer clientPlayer = (LocalPlayer)player;
                if (clientPlayer.m_150110_().f_35935_ && Minecraft.m_91087_().m_91288_() == clientPlayer) {
                    float j = 0.0f;
                    if (clientPlayer.f_108618_.f_108573_) {
                        j -= 1.0f;
                    }
                    if (clientPlayer.f_108618_.f_108572_) {
                        j += 1.0f;
                    }
                    if (j != 0.0f) {
                        Vec3 deltaMovement = clientPlayer.m_20184_();
                        clientPlayer.m_20256_(deltaMovement.m_82520_(0.0, (double)((j *= ((VerticalSpeed)((Object)this.getVerticalSpeed().get())).getSpeed() - 1.0f) * clientPlayer.m_150110_().m_35942_() * 3.0f), 0.0));
                    }
                }
            }
        }
    }

    public void changeMode(IModule<ModuleGravitationalModulatingAdditionalUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        VerticalSpeed nextSpeed;
        VerticalSpeed prevSpeed;
        if (module.isEnabled() && (prevSpeed = (VerticalSpeed)((Object)this.getVerticalSpeed().get())) != (nextSpeed = (VerticalSpeed)prevSpeed.adjust(shift))) {
            this.getVerticalSpeed().set((Object)nextSpeed);
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)GMUTLang.MODULE_VERTICAL_SPEED.translate(new Object[0]), (IHasTextComponent)nextSpeed);
            }
        }
    }

    public IModuleConfigItem<Boolean> getFlyAlways() {
        return this.flyAlways;
    }

    public IModuleConfigItem<Boolean> getStopImmediately() {
        return this.stopImmediately;
    }

    public IModuleConfigItem<Boolean> getFixFOV() {
        return this.fixFOV;
    }

    public IModuleConfigItem<VerticalSpeed> getVerticalSpeed() {
        return this.verticalSpeed;
    }
}

