/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import ovh.corail.tombstone.network.CMessageConfig;
import ovh.corail.tombstone.network.CMessageCooldown;
import ovh.corail.tombstone.network.CMessageEffectFinished;
import ovh.corail.tombstone.network.CMessageEffectStarted;
import ovh.corail.tombstone.network.CMessageFamiliar;
import ovh.corail.tombstone.network.CMessageKnowledgeScreen;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessageLogin;
import ovh.corail.tombstone.network.CMessagePlayerProtection;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.CMessageSmokeColumn;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.network.SMessagePlayerPreference;
import ovh.corail.tombstone.network.SMessageResetPerk;
import ovh.corail.tombstone.network.SMessageUpgradePerk;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "tombstone-8.9.4";
    private static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tombstone", "tombstone_channel"), () -> "tombstone-8.9.4", "tombstone-8.9.4"::equals, "tombstone-8.9.4"::equals);

    public static <T> void sendToServer(T message) {
        HANDLER.sendToServer(message);
    }

    public static <T> void sendToPlayer(T message, ServerPlayer player) {
        HANDLER.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <T> void sendToAllTrackingPlayers(T message, LivingEntity entity) {
        HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <T> void sendToAllTrackingPlayersAndSelf(T message, LivingEntity entity) {
        HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), message);
    }

    public static <T> void sendToAllPlayers(T message) {
        HANDLER.send(PacketDistributor.ALL.noArg(), message);
    }

    static {
        int id = -1;
        HANDLER.registerMessage(++id, SMessagePlayerPreference.class, SMessagePlayerPreference::toBytes, SMessagePlayerPreference::fromBytes, SMessagePlayerPreference.Handler::handle);
        HANDLER.registerMessage(++id, CMessageLogin.class, CMessageLogin::toBytes, CMessageLogin::fromBytes, CMessageLogin.Handler::handle);
        HANDLER.registerMessage(++id, CMessageTBCapability.class, CMessageTBCapability::toBytes, CMessageTBCapability::fromBytes, CMessageTBCapability.Handler::handle);
        HANDLER.registerMessage(++id, SMessageUpgradePerk.class, SMessageUpgradePerk::toBytes, SMessageUpgradePerk::fromBytes, SMessageUpgradePerk.Handler::handle);
        HANDLER.registerMessage(++id, CMessageSmokeColumn.class, CMessageSmokeColumn::toBytes, CMessageSmokeColumn::fromBytes, CMessageSmokeColumn.Handler::handle);
        HANDLER.registerMessage(++id, CMessageConfig.class, CMessageConfig::toBytes, CMessageConfig::fromBytes, CMessageConfig.Handler::handle);
        HANDLER.registerMessage(++id, CMessageCooldown.class, CMessageCooldown::toBytes, CMessageCooldown::fromBytes, CMessageCooldown.Handler::handle);
        HANDLER.registerMessage(++id, CMessagePrayer.class, CMessagePrayer::toBytes, CMessagePrayer::fromBytes, CMessagePrayer.Handler::handle);
        HANDLER.registerMessage(++id, CMessageProtection.class, CMessageProtection::toBytes, CMessageProtection::fromBytes, CMessageProtection.Handler::handle);
        HANDLER.registerMessage(++id, CMessagePlayerProtection.class, CMessagePlayerProtection::toBytes, CMessagePlayerProtection::fromBytes, CMessagePlayerProtection.Handler::handle);
        HANDLER.registerMessage(++id, SMessageResetPerk.class, SMessageResetPerk::toBytes, SMessageResetPerk::fromBytes, SMessageResetPerk.Handler::handle);
        HANDLER.registerMessage(++id, CMessageKnowledgeScreen.class, CMessageKnowledgeScreen::toBytes, CMessageKnowledgeScreen::fromBytes, CMessageKnowledgeScreen.Handler::handle);
        HANDLER.registerMessage(++id, CMessageSpellCasting.class, CMessageSpellCasting::toBytes, CMessageSpellCasting::fromBytes, CMessageSpellCasting.Handler::handle);
        HANDLER.registerMessage(++id, CMessageServant.class, CMessageServant::toBytes, CMessageServant::fromBytes, CMessageServant.Handler::handle);
        HANDLER.registerMessage(++id, CMessageLevelUp.class, CMessageLevelUp::toBytes, CMessageLevelUp::fromBytes, CMessageLevelUp.Handler::handle);
        HANDLER.registerMessage(++id, CMessageFamiliar.class, CMessageFamiliar::toBytes, CMessageFamiliar::fromBytes, CMessageFamiliar.Handler::handle);
        HANDLER.registerMessage(++id, SMessageCombination.class, SMessageCombination::toBytes, SMessageCombination::fromBytes, SMessageCombination.Handler::handle);
        HANDLER.registerMessage(++id, CMessageEffectStarted.class, CMessageEffectStarted::toBytes, CMessageEffectStarted::fromBytes, CMessageEffectStarted.Handler::handle);
        HANDLER.registerMessage(++id, CMessageEffectFinished.class, CMessageEffectFinished::toBytes, CMessageEffectFinished::fromBytes, CMessageEffectFinished.Handler::handle);
    }
}

