/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModLootFunctions;
import ovh.corail.tombstone.registry.ModTags;

public class EnchantedEquipmentFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "enchanted_equipment");
    public static final Serializer SERIALIZER = new Serializer();
    private final Type type;
    private final boolean onlyVanilla;
    private final int enchantedChance;
    private final int randomEnchantibility;

    protected EnchantedEquipmentFunction(LootItemCondition[] conditionsIn, Type type, boolean onlyVanilla, int enchantedChance, int randomEnchantibility) {
        super(conditionsIn);
        this.type = type;
        this.onlyVanilla = onlyVanilla;
        this.enchantedChance = enchantedChance;
        this.randomEnchantibility = randomEnchantibility;
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.ENCHANTED_EQUIPMENT;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        RandomWeightedItem generator = this.onlyVanilla ? LootHelper.getItemGenerator(this.type == Type.WEAPON ? ModTags.Items.lootable_vanilla_weapon : (this.type == Type.ARMOR ? ModTags.Items.lootable_vanilla_armor : ModTags.Items.lootable_vanilla_tool)) : LootHelper.getItemGenerator(this.type == Type.WEAPON ? ModTags.Items.lootable_weapon : (this.type == Type.ARMOR ? ModTags.Items.lootable_armor : ModTags.Items.lootable_tool));
        ItemStack result = ItemStack.f_41583_;
        for (int i = 0; i < 3; ++i) {
            ResourceLocation registryName;
            @Nullable Item item = generator.getRandomItem();
            if (item == null || (registryName = RegistryHelper.getRegistryName(item)) == null || ((List)ConfigTombstone.loot.deniedModidForEquipment.get()).contains(registryName.m_135827_())) continue;
            result = new ItemStack((ItemLike)item);
            break;
        }
        if (result.m_41619_()) {
            result = new ItemStack((ItemLike)Items.f_42690_);
        }
        if (Helper.RANDOM.nextInt(5) == 0) {
            NBTStackHelper.setBoolean(result, "soulbound", true);
        }
        if (result.m_41792_() && result.getEnchantmentValue() > 0 && Helper.RANDOM.nextInt(100) < this.enchantedChance) {
            EnchantmentHelper.m_44865_(Helper.getRandomEnchantments(result.getEnchantmentValue() + Helper.RANDOM.nextInt(this.randomEnchantibility), result, Helper.RANDOM.nextInt(4) + 1), (ItemStack)result);
        }
        return result;
    }

    public static enum Type {
        WEAPON,
        ARMOR,
        TOOL;

    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<EnchantedEquipmentFunction> {
        public EnchantedEquipmentFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new EnchantedEquipmentFunction(conditionsIn, Type.values()[GsonHelper.m_13824_((JsonObject)json, (String)"type", (int)0)], GsonHelper.m_13855_((JsonObject)json, (String)"onlyVanilla", (boolean)false), GsonHelper.m_13824_((JsonObject)json, (String)"enchantedChance", (int)50), GsonHelper.m_13824_((JsonObject)json, (String)"randomEnchantibility", (int)0));
        }

        public void serialize(JsonObject json, EnchantedEquipmentFunction fct, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)fct, serializationContext);
            json.addProperty("type", (Number)fct.type.ordinal());
            json.addProperty("onlyVanilla", Boolean.valueOf(fct.onlyVanilla));
            json.addProperty("enchantedChance", (Number)fct.enchantedChance);
            json.addProperty("randomEnchantibility", (Number)fct.randomEnchantibility);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Type type;
        private final boolean onlyVanilla;
        private final int enchantedChance;
        private final int randomEnchantibility;

        public Builder(Type type, boolean onlyVanilla, int enchantedChance, int randomEnchantibility) {
            this.type = type;
            this.onlyVanilla = onlyVanilla;
            this.enchantedChance = enchantedChance;
            this.randomEnchantibility = randomEnchantibility;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new EnchantedEquipmentFunction(this.m_80699_(), this.type, this.onlyVanilla, this.enchantedChance, this.randomEnchantibility);
        }
    }
}

