/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.registry.ModDamages;

public enum DamageCategory implements StringRepresentable
{
    SUFFOCATION(d -> d.m_269533_(DamageTypeTags.f_268581_) || d.m_276093_(DamageTypes.f_268612_) || d.m_276093_(DamageTypes.f_268613_) || d.m_276093_(DamageTypes.f_268441_)),
    BURN(d -> d.m_269533_(DamageTypeTags.f_268745_)),
    LIGHTNING(d -> d.m_269533_(DamageTypeTags.f_268725_)),
    FALL(d -> d.m_269533_(DamageTypeTags.f_268549_) || d.m_276093_(DamageTypes.f_268576_)),
    COLD(d -> d.m_269533_(DamageTypeTags.f_268419_)),
    DARKNESS(d -> d.m_276093_(DamageTypes.f_268493_) || d.m_276093_(DamageTypes.f_268641_) || d.m_276093_(DamageTypes.f_268482_) || d.m_276093_(ModDamages.UNHOLY)),
    LIGHT(d -> d.m_276093_(ModDamages.HOLY)),
    UNKNOWN(d -> false);

    private final String name = this.name().toLowerCase(Locale.US);
    private final Predicate<DamageSource> is;

    private DamageCategory(Predicate<DamageSource> predic) {
        this.is = predic;
    }

    public static boolean isProjectile(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_269533_(DamageTypeTags.f_268524_);
    }

    public static boolean isExplosion(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_269533_(DamageTypeTags.f_268415_);
    }

    public static boolean isThorn(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_276093_(DamageTypes.f_268440_);
    }

    public boolean is(DamageSource s) {
        return this.is.test(s);
    }

    public static DamageCategory of(DamageSource s) {
        for (DamageCategory damageCategory : DamageCategory.values()) {
            if (!damageCategory.is(s)) continue;
            return damageCategory;
        }
        return UNKNOWN;
    }

    public String m_7912_() {
        return this.name;
    }
}

