/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.BlockHorizontalWaterLogged;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.registry.ModTriggers;

public class BlockAbandonedGrave
extends BlockHorizontalWaterLogged {
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.m_61631_((String)"model_texture", (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1));
    private static final EnumMap<Direction, VoxelShape> COLLISIONS = new EnumMap(Direction.class);

    public BlockAbandonedGrave() {
        super(BlockAbandonedGrave.getBuilder());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MODEL_TEXTURE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!EntityHelper.isValidPlayer(player)) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.rewardKnowledge(serverPlayer, 5));
            LootParams lootParams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287239_(serverPlayer.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)serverPlayer).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList stacks = LootHelper.getLootTable(UpdaterHandler.PoolType.ABANDONED_GRAVE).m_287195_(lootParams);
            for (ItemStack stack : stacks) {
                ItemHandlerHelper.giveItemToPlayer((Player)serverPlayer, (ItemStack)stack);
            }
            level.m_5594_(null, pos, SoundEvents.f_12601_, SoundSource.BLOCKS, 0.5f, 0.5f);
            ModTriggers.TOMB_RAIDING.trigger(serverPlayer);
            LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((Player)serverPlayer, new Object[0]);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return COLLISIONS.computeIfAbsent((Direction)state.m_61143_((Property)f_54117_), direction -> Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.125, (double)0.875), Shapes.m_83048_((double)0.3125, (double)0.125, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875), Shapes.m_83048_((double)0.4025, (double)0.375, (double)0.4025, (double)0.59375, (double)0.53125, (double)0.59375), Helper.createShapeForDirection(direction, 0.28125, 0.53125, 0.4375, 0.71875, 0.96875, 0.5625)}));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return false;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return 0.0f;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return null;
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(20.0f, 1.8E7f).m_60918_(SoundType.f_56742_).m_278166_(PushReaction.IGNORE).m_60991_((state, level, pos) -> true).m_60953_(state -> 5);
    }
}

