/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.liquifier;

import com.smashingmods.alchemistry.datagen.recipe.liquifier.LiquifierRecipeBuilder;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.datagen.DatagenHelpers;
import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.registry.FluidRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class LiquifierRecipeProvider {
    private final Consumer<FinishedRecipe> consumer;

    public LiquifierRecipeProvider(Consumer<FinishedRecipe> pConsumer) {
        this.consumer = pConsumer;
    }

    public static void register(Consumer<FinishedRecipe> pConsumer) {
        new LiquifierRecipeProvider(pConsumer).register();
    }

    private void register() {
        ItemRegistry.getElements().stream().filter(element -> element.getMatterState().equals((Object)MatterState.LIQUID) || element.getMatterState().equals((Object)MatterState.GAS) && !element.isArtificial()).forEach(this.fluidToChemicalRecipe());
        ItemRegistry.getCompounds().stream().filter(compound -> compound.getMatterState().equals((Object)MatterState.LIQUID) || compound.getMatterState().equals((Object)MatterState.GAS)).forEach(this.fluidToChemicalRecipe());
        ItemRegistry.getCompoundByName((String)"water").ifPresent(water -> this.liquifier(new ItemStack((ItemLike)water, 8), new FluidStack((Fluid)Fluids.f_76193_, 500)));
    }

    private Consumer<? super Chemical> fluidToChemicalRecipe() {
        return chemical -> FluidRegistry.FLUIDS.getEntries().stream().map(RegistryObject::get).filter(fluid -> Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey(fluid)).m_135815_().contentEquals(String.format("%s_fluid", chemical.getChemicalName()))).findFirst().map(fluid -> new FluidStack(fluid, 500)).ifPresent(fluidStack -> this.liquifier(new ItemStack((ItemLike)chemical, 8), (FluidStack)fluidStack));
    }

    private void liquifier(String pItemTag, FluidStack pOutput) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(pItemTag));
        this.liquifier(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey)), pOutput);
    }

    private void liquifier(ItemStack pInput, FluidStack pOutput) {
        this.liquifier(new IngredientStack(pInput), pOutput);
    }

    private void liquifier(IngredientStack pInput, FluidStack pOutput, ICondition pCondition) {
        ResourceLocation recipeId = ForgeRegistries.FLUIDS.getKey((Object)pOutput.getFluid());
        ConditionalRecipe.builder().addCondition(pCondition).addRecipe(arg_0 -> ((RecipeBuilder)LiquifierRecipeBuilder.createRecipe(pInput, pOutput, Objects.requireNonNull(recipeId)).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((FluidStack)pOutput, (String)"liquifier", (String)"alchemistry")))).m_176498_(arg_0)).build(this.consumer, new ResourceLocation("alchemistry", String.format("liquifier/%s", recipeId.m_135815_())));
    }

    private void liquifier(IngredientStack pInput, FluidStack pOutput) {
        LiquifierRecipeBuilder.createRecipe(pInput, pOutput, Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)pOutput.getFluid()))).m_126145_(String.format("%s:liquifier", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((FluidStack)pOutput, (String)"liquifier", (String)"alchemistry"))).m_176498_(this.consumer);
    }
}

