/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.emrys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.entity.MahouLightningBoltEntity;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.StaffEmrysRenderer;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class StaffEmrys
extends ItemBase {
    public static HashMap<UUID, StaffEmrysUserStorage> staffs = new HashMap();

    public StaffEmrys() {
        super("staff_emrys", new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        staffs.remove(player.m_20148_());
        if (handIn == InteractionHand.OFF_HAND) {
            player.m_6672_(handIn);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(handIn));
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.m_21120_(handIn));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        StaffEmrysUserStorage storage;
        if (staffs.containsKey(player.m_20148_())) {
            storage = staffs.get(player.m_20148_());
        } else {
            storage = new StaffEmrysUserStorage();
            staffs.put(player.m_20148_(), storage);
        }
        if (!player.m_9236_().f_46443_ && player instanceof Player && PlayerManaManager.drainMana((Player)player, MTConfig.EMRYS_MANA_COST_FOCUSED / 20, false, false) == MTConfig.EMRYS_MANA_COST_FOCUSED / 20) {
            double d = 30.0;
            double addX = (double)((float)player.m_217043_().m_188503_((int)d) + player.m_217043_().m_188501_()) - d / 2.0;
            double addZ = (double)((float)player.m_217043_().m_188503_((int)d) + player.m_217043_().m_188501_()) - d / 2.0;
            double addY = player.m_217043_().m_188503_(2) - 2;
            int charge = this.getRemainingUseDuration(stack, count);
            ((ServerLevel)player.m_9236_()).f_46438_ = Math.min((float)charge / 40.0f, 2.4f);
            ((ServerLevel)player.m_9236_()).f_46440_ = Math.min((float)charge / 40.0f, 2.4f);
            if ((float)charge / 15.0f > 2.4f) {
                if (player.m_217043_().m_188501_() < 0.2f) {
                    StaffEmrys.addLightningBolt((ServerLevel)player.m_9236_(), new MahouLightningBoltEntity(player.m_9236_(), player.m_20185_() + addX, player.m_20186_() + addY, player.m_20189_() + addZ, false));
                }
                boolean ball = true;
                if (storage.lightnings != null) {
                    for (int i = 0; i < storage.lightnings.size(); ++i) {
                        if (storage.lightnings.get(i).m_6084_() && ball) {
                            storage.lightnings.get(i).setHasBall(ball);
                            ball = false;
                            continue;
                        }
                        storage.lightnings.get(i).setHasBall(false);
                    }
                }
                if (ServerHandler.tickCounter % 10L == 0L) {
                    float radius = MTConfig.EMRYS_MAX_RANGE;
                    AABB aabb = new AABB(player.m_20185_() - (double)radius, player.m_20186_() - (double)radius, player.m_20189_() - (double)radius, player.m_20185_() + (double)radius, player.m_20186_() + (double)(radius * 2.0f), player.m_20189_() + (double)radius);
                    List lst = player.m_9236_().m_45976_(LivingEntity.class, aabb);
                    Vec3 myloc = player.m_20182_();
                    lst.sort((e1, e2) -> (int)(e1.m_20182_().m_82557_(myloc) - e2.m_20182_().m_82557_(myloc)));
                    storage.lightnings.removeIf(a -> !a.m_6084_());
                    storage.connected = new HashSet();
                    storage.lightnings.forEach(a -> {
                        if (a != null && a.target != null) {
                            storage.connected.add(a.target.m_20148_());
                        }
                    });
                    for (LivingEntity e : lst) {
                        if (storage.lightnings.size() >= 3) break;
                        if (e.m_20148_().equals(player.m_20148_()) || storage.connected.contains(e.m_20148_()) || ContractMahoujinTileEntity.isImmuneToSpell(player.m_9236_(), player.m_20148_(), (Entity)e) || !this.validTarget(player, e)) continue;
                        LightningEntity le = new LightningEntity(player.m_9236_(), player, e, 1.0f, 1.0f, 1.0f, 1.0f, 0.02f, false);
                        player.m_9236_().m_7967_((Entity)le);
                        storage.lightnings.add(le);
                    }
                    if (storage.lightnings != null) {
                        for (int i = 0; i < storage.lightnings.size(); ++i) {
                            if (i == 0) {
                                storage.lightnings.get(i).setHasBall(true);
                                continue;
                            }
                            storage.lightnings.get(i).setHasBall(false);
                        }
                    }
                }
            }
        }
    }

    public boolean validTarget(LivingEntity caster, LivingEntity target) {
        if (!target.m_6084_()) {
            return false;
        }
        boolean inrange = EffectUtil.inRange(target, caster, caster.m_20182_(), MTConfig.EMRYS_MAX_RANGE, false);
        if (inrange) {
            Vec3 targetEye = target.m_20299_(1.0f);
            Vec3 casterEye = caster.m_20299_(1.0f);
            Vec3 diff = targetEye.m_82546_(casterEye);
            double len = diff.m_82553_();
            Vec3 dir = diff.m_82541_();
            int i = 0;
            while ((double)i < len) {
                BlockPos p = Utils.toBlockPos(casterEye.m_82549_(dir.m_82490_((double)i)));
                if (!caster.m_9236_().m_46859_(p)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity caster, int t) {
        if (caster != null) {
            StaffEmrysUserStorage storage;
            if (staffs.containsKey(caster.m_20148_())) {
                storage = staffs.get(caster.m_20148_());
            } else {
                storage = new StaffEmrysUserStorage();
                staffs.put(caster.m_20148_(), storage);
            }
            if (!world.f_46443_) {
                for (LightningEntity e : storage.lightnings) {
                    e.m_146870_();
                }
                staffs.remove(caster.m_20148_());
            }
        }
        super.m_5551_(stack, world, caster, t);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public static void addLightningBolt(ServerLevel world, MahouLightningBoltEntity entityIn) {
        world.m_7967_((Entity)entityIn);
    }

    public static void zap(LivingEntity e, boolean ignoreZapped, Player caster) {
        if (e != null && !e.m_9236_().f_46443_) {
            int radius = 4;
            AABB aabb = new AABB(e.m_20185_() - (double)radius, e.m_20186_() - (double)radius, e.m_20189_() - (double)radius, e.m_20185_() + (double)radius, e.m_20186_() + (double)radius, e.m_20189_() + (double)radius);
            List lst = e.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity target : lst) {
                if (EffectUtil.hasBuff(target, ModEffects.ZAP_COOLDOWN) && !ignoreZapped || target.m_21205_().m_41720_() == ModItems.emrysStaff.get() || target.m_21206_().m_41720_() == ModItems.emrysStaff.get() || caster == null || PlayerManaManager.drainMana(caster, MTConfig.EMRYS_MANA_COST_PASSIVE, false, false) != MTConfig.EMRYS_MANA_COST_PASSIVE) continue;
                target.m_9236_().m_7967_((Entity)new LightningEntity(e.m_9236_(), e, target, 1.0f, 1.0f, 1.0f, 1.0f, 0.01f, true));
            }
        }
    }

    public static void emrysHit(AttackEntityEvent event) {
        if (event.getEntity().m_21206_().m_41720_() == ModItems.emrysStaff.get() && !event.getEntity().m_9236_().f_46443_ && event.getTarget() instanceof LivingEntity && event.getEntity() instanceof Player) {
            StaffEmrys.zap((LivingEntity)event.getTarget(), false, event.getEntity());
        }
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.m_8105_(stack) - charge;
    }

    public static void emrysLivingHurt(LivingHurtEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            if ((event.getEntity().m_21206_().m_41720_() == ModItems.emrysStaff.get() || event.getEntity().m_21205_().m_41720_() == ModItems.emrysStaff.get()) && Utils.damageSourceAny(event.getSource(), DamageTypes.f_268450_)) {
                event.setAmount(0.0f);
            }
            if (event.getSource().m_7639_() instanceof Player && ((LivingEntity)event.getSource().m_7639_()).m_21206_().m_41720_() == ModItems.emrysStaff.get()) {
                StaffEmrys.zap(event.getEntity(), false, (Player)event.getSource().m_7639_());
            }
        }
    }

    public static void emrysStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().f_46443_ && !MTConfig.DISABLE_EMRYS && ((LivingEntity)event.getEntity()).m_21206_().m_41720_() == Items.f_42398_ && StrengtheningSpellEffect.getStrengthened(((LivingEntity)event.getEntity()).m_21206_()) > 0) {
            ItemStack emrys = new ItemStack((ItemLike)ModItems.emrysStaff.get());
            StaffEmrys.turnStickIntoItem((Player)event.getEntity(), emrys);
        }
    }

    public static void turnStickIntoItem(Player player, ItemStack change) {
        ItemStack stack;
        if (player.m_150109_().f_35976_.size() > 0 && (stack = (ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_() == Items.f_42398_ && StrengtheningSpellEffect.getStrengthened(stack) > 0) {
            player.m_150109_().f_35976_.set(0, (Object)change);
            ModTriggers.EMRYS.trigger((ServerPlayer)player);
        }
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(StaffEmrysRenderer::new);
    }

    public class StaffEmrysUserStorage {
        public ArrayList<LightningEntity> lightnings = new ArrayList();
        public HashSet<UUID> connected = new HashSet();
    }
}

