/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils.interpolate;

import com.lowdragmc.lowdraglib.utils.interpolate.IEase;
import java.util.function.Consumer;

public class Interpolator {
    private final float from;
    private final float to;
    private final float durationTick;
    private final IEase ease;
    private final Consumer<Number> interpolate;
    private final Consumer<Number> callback;
    private float tick = -1.0f;
    private float startTick = 0.0f;

    public Interpolator(float from, float to, float durationTick, IEase ease, Consumer<Number> interpolate) {
        this(from, to, durationTick, ease, interpolate, null);
    }

    public Interpolator(float from, float to, float durationTick, IEase ease, Consumer<Number> interpolate, Consumer<Number> callback) {
        this.from = from;
        this.to = to;
        this.durationTick = durationTick;
        this.ease = ease;
        this.interpolate = interpolate;
        this.callback = callback;
    }

    public void reset() {
        this.tick = -1.0f;
    }

    public boolean isFinish() {
        return this.tick == this.durationTick;
    }

    public void update(float tickTime) {
        if (this.tick == -2.0f) {
            return;
        }
        if (this.tick == -1.0f) {
            this.startTick = tickTime;
        }
        if (this.tick - this.startTick >= this.durationTick) {
            this.tick = -2.0f;
            if (this.interpolate != null) {
                this.interpolate.accept(Float.valueOf(this.ease.getInterpolation(1.0f) * (this.to - this.from) + this.from));
            }
            if (this.callback != null) {
                this.callback.accept(Float.valueOf(this.ease.getInterpolation(1.0f) * (this.to - this.from) + this.from));
            }
        } else {
            this.tick = tickTime;
            if (this.interpolate != null) {
                this.interpolate.accept(Float.valueOf(this.ease.getInterpolation((this.tick - this.startTick) / this.durationTick) * (this.to - this.from) + this.from));
            }
        }
    }
}

