/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface IFluidTransfer {
    public static final IFluidTransfer EMPTY = new IFluidTransfer(){

        @Override
        public int getTanks() {
            return 0;
        }

        @Override
        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.empty();
        }

        @Override
        public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        }

        @Override
        public long getTankCapacity(int tank) {
            return 0L;
        }

        @Override
        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return false;
        }

        @Override
        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return 0L;
        }

        @Override
        public boolean supportsFill(int tank) {
            return false;
        }

        @Override
        @NotNull
        public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return FluidStack.empty();
        }

        @Override
        public boolean supportsDrain(int tank) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return new Object();
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
        }
    };

    public int getTanks();

    @Nonnull
    public FluidStack getFluidInTank(int var1);

    @ApiStatus.Internal
    public void setFluidInTank(int var1, @Nonnull FluidStack var2);

    public long getTankCapacity(int var1);

    public boolean isFluidValid(int var1, @Nonnull FluidStack var2);

    @ApiStatus.Internal
    public long fill(int var1, FluidStack var2, boolean var3, boolean var4);

    public boolean supportsFill(int var1);

    @Nonnull
    @ApiStatus.Internal
    public FluidStack drain(int var1, FluidStack var2, boolean var3, boolean var4);

    public boolean supportsDrain(int var1);

    default public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (resource.isEmpty()) {
            return 0L;
        }
        long filled = 0L;
        for (int i = 0; i < this.getTanks() && (filled += this.fill(i, resource.copy(resource.getAmount() - filled), simulate, false)) != resource.getAmount(); ++i) {
        }
        if (notifyChanges && filled > 0L && !simulate) {
            this.onContentsChanged();
        }
        return filled;
    }

    default public long fill(FluidStack resource, boolean simulate) {
        return this.fill(resource, simulate, !simulate);
    }

    @Nonnull
    default public FluidStack drain(FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (resource.isEmpty()) {
            return FluidStack.empty();
        }
        long drained = 0L;
        for (int i = 0; i < this.getTanks() && (drained += this.drain(i, resource.copy(resource.getAmount() - drained), simulate, false).getAmount()) != resource.getAmount(); ++i) {
        }
        if (notifyChanges && drained > 0L && !simulate) {
            this.onContentsChanged();
        }
        return resource.copy(drained);
    }

    default public FluidStack drain(FluidStack resource, boolean simulate) {
        return this.drain(resource, simulate, !simulate);
    }

    @Nonnull
    default public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChanges) {
        if (maxDrain == 0L) {
            return FluidStack.empty();
        }
        FluidStack totalDrained = null;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack handler = this.getFluidInTank(i);
            if (handler.isEmpty()) continue;
            if (totalDrained == null) {
                totalDrained = handler.copy();
                totalDrained.setAmount(Math.min(maxDrain, totalDrained.getAmount()));
                maxDrain -= totalDrained.getAmount();
                if (!simulate) {
                    handler.shrink(totalDrained.getAmount());
                    if (notifyChanges) {
                        this.onContentsChanged();
                    }
                }
            } else if (totalDrained.isFluidEqual(handler)) {
                long toDrain = Math.min(maxDrain, handler.getAmount());
                maxDrain -= toDrain;
                totalDrained.grow(toDrain);
                if (!simulate) {
                    handler.shrink(toDrain);
                    if (notifyChanges) {
                        this.onContentsChanged();
                    }
                }
            }
            if (maxDrain <= 0L) break;
        }
        return totalDrained == null ? FluidStack.empty() : totalDrained;
    }

    default public FluidStack drain(long maxDrain, boolean simulate) {
        return this.drain(maxDrain, simulate, !simulate);
    }

    default public void onContentsChanged() {
    }

    @Nonnull
    @ApiStatus.Internal
    public Object createSnapshot();

    @ApiStatus.Internal
    public void restoreFromSnapshot(Object var1);
}

