/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularForegroundRecipeWidget;
import com.lowdragmc.lowdraglib.jei.ModularUIGuiEventListener;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ModularUIRecipeCategory<T>
implements IRecipeCategory<T> {
    private final LoadingCache<T, ModularWrapper<?>> modularWrapperCache;

    @Deprecated
    protected ModularUIRecipeCategory() {
        this(t -> (ModularWrapper)((Object)((Object)t)));
    }

    protected ModularUIRecipeCategory(final Function<T, ModularWrapper<?>> wrapperFunction) {
        this.modularWrapperCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).maximumSize(10L).build(new CacheLoader<T, ModularWrapper<?>>(){

            public ModularWrapper<?> load(T key) {
                return (ModularWrapper)((Object)wrapperFunction.apply(key));
            }
        });
    }

    private ModularWrapper<?> getModularWrapper(T recipe) {
        return (ModularWrapper)((Object)this.modularWrapperCache.getUnchecked(recipe));
    }

    private static void addJEISlot(IRecipeLayoutBuilder builder, final IRecipeIngredientSlot slot, RecipeIngredientRole role, int index) {
        String slotName = "slot_" + index;
        IRecipeSlotBuilder slotBuilder = builder.addSlot(role, slot.self().getPositionX(), slot.self().getPositionY());
        HashMap<IIngredientType, List> ingredientMap = new HashMap<IIngredientType, List>();
        for (Object object : slot.getXEIIngredients()) {
            if (!(object instanceof IClickableIngredient)) continue;
            IClickableIngredient clickableIngredient = (IClickableIngredient)object;
            ingredientMap.computeIfAbsent(clickableIngredient.getIngredientType(), k -> new ArrayList()).add(clickableIngredient.getIngredient());
        }
        for (Map.Entry entry : ingredientMap.entrySet()) {
            IIngredientType type = (IIngredientType)entry.getKey();
            List ingredients = (List)entry.getValue();
            slotBuilder.addIngredients(type, ingredients);
            slotBuilder.setCustomRenderer(type, (IIngredientRenderer)new IIngredientRenderer<Object>(){

                public void render(GuiGraphics guiGraphics, Object ingredient) {
                    slot.setCurrentJEIRenderedIngredient(ingredient);
                }

                public List<Component> getTooltip(Object ingredient, TooltipFlag tooltipFlag) {
                    return Collections.emptyList();
                }

                public void getTooltip(ITooltipBuilder tooltip, Object ingredient, TooltipFlag tooltipFlag) {
                    tooltip.addAll(slot.getFullTooltipTexts());
                }

                public int getWidth() {
                    return slot.self().getSizeWidth();
                }

                public int getHeight() {
                    return slot.self().getSizeHeight();
                }
            });
        }
        slotBuilder.setSlotName(slotName);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        ModularWrapper<?> wrapper = this.getModularWrapper(recipe);
        wrapper.setRecipeWidget(0, 0);
        List<Widget> flatVisibleWidgetCollection = wrapper.modularUI.getFlatWidgetCollection();
        for (int i = 0; i < flatVisibleWidgetCollection.size(); ++i) {
            Widget widget = flatVisibleWidgetCollection.get(i);
            if (!(widget instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)widget);
            RecipeIngredientRole role = ModularUIRecipeCategory.mapToRole(slot.getIngredientIO());
            if (role == null) {
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.INPUT, i);
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.OUTPUT, i);
                continue;
            }
            ModularUIRecipeCategory.addJEISlot(builder, slot, role, i);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
        ModularWrapper<?> wrapper = this.getModularWrapper(recipe);
        builder.addGuiEventListener(new ModularUIGuiEventListener(wrapper));
        builder.addWidget((IRecipeWidget)new ModularForegroundRecipeWidget(wrapper));
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ModularWrapper<?> wrapper = this.getModularWrapper(recipe);
        wrapper.draw(guiGraphics, (int)mouseX, (int)mouseY, Minecraft.m_91087_().m_91296_());
    }

    public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        ModularWrapper<?> wrapper = this.getModularWrapper(recipe);
        if (wrapper.tooltipTexts != null && !wrapper.tooltipTexts.isEmpty()) {
            tooltip.addAll((Collection)wrapper.tooltipTexts);
        }
        if (wrapper.tooltipComponent != null) {
            tooltip.add(wrapper.tooltipComponent);
        }
    }

    @Nullable
    public static RecipeIngredientRole mapToRole(IngredientIO ingredientIO) {
        return switch (ingredientIO) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientIO.INPUT -> RecipeIngredientRole.INPUT;
            case IngredientIO.OUTPUT -> RecipeIngredientRole.OUTPUT;
            case IngredientIO.CATALYST -> RecipeIngredientRole.CATALYST;
            case IngredientIO.RENDER_ONLY -> RecipeIngredientRole.RENDER_ONLY;
            case IngredientIO.BOTH -> null;
        };
    }
}

