/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.mod;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.impl.config.ModMappers;
import org.moddingx.libx.mod.ModXRegistration;

public abstract class ModX {
    public final String modid;

    protected ModX() {
        Class<?> cls = this.getClass();
        Mod mod = cls.getAnnotation(Mod.class);
        if (mod == null) {
            throw new IllegalStateException("Mod class has no @Mod annotation.");
        }
        this.modid = mod.value();
        ModInternal.init(this, FMLJavaModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        ModMappers.get(this.modid).initAdapter(ModLoadingContext.get());
        if (!(this instanceof ModXRegistration)) {
            ModInternal.get(this).callGeneratedCode();
        }
    }

    protected abstract void setup(FMLCommonSetupEvent var1);

    protected abstract void clientSetup(FMLClientSetupEvent var1);

    public final ResourceLocation resource(String path) {
        return new ResourceLocation(this.modid, path);
    }
}

